<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ModifyJenjangColumn extends Migration
{
    public function up()
    {
        // Change jenjang column from ENUM to VARCHAR for more flexibility
        $this->forge->modifyColumn('tb_pendidikan', [
            'jenjang' => [
                'type'       => 'VARCHAR',
                'constraint' => 50,
                'null'       => true,
            ],
        ]);
    }

    public function down()
    {
        // Revert back to ENUM (note: this may fail if data contains values not in ENUM)
        $this->forge->modifyColumn('tb_pendidikan', [
            'jenjang' => [
                'type'       => 'ENUM',
                'constraint' => ['SD', 'SMP', 'SMA', 'Kuliah'],
            ],
        ]);
    }
}
