<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddVideoToTbAktivitas extends Migration
{
    public function up()
    {
        // Add new columns for video support
        $this->forge->addColumn('tb_aktivitas', [
            'tipe' => [
                'type'       => 'ENUM',
                'constraint' => ['foto', 'video'],
                'default'    => 'foto',
                'after'      => 'foto',
            ],
            'video' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
                'after'      => 'tipe',
            ],
            'thumbnail' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
                'after'      => 'video',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('tb_aktivitas', ['tipe', 'video', 'thumbnail']);
    }
}
