<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTbGaleri extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'judul' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
            ],
            'deskripsi' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'tipe' => [
                'type'       => 'ENUM',
                'constraint' => ['foto', 'video'],
                'default'    => 'foto',
            ],
            'file' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'comment'    => 'Main file (image or video)',
            ],
            'thumbnail' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
                'comment'    => 'Thumbnail for video',
            ],
            'tanggal' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('tb_galeri');
    }

    public function down()
    {
        $this->forge->dropTable('tb_galeri');
    }
}
