<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTbBahasa extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nama_bahasa' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
            ],
            'tingkat' => [
                'type'       => 'ENUM',
                'constraint' => ['Pemula', 'Menengah', 'Mahir', 'Expert'],
                'default'    => 'Pemula',
            ],
            'icon_class' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => true,
                'comment'    => 'Icon class or SVG identifier',
            ],
            'warna' => [
                'type'       => 'VARCHAR',
                'constraint' => 20,
                'null'       => true,
                'comment'    => 'Hex color code for the language',
            ],
            'urutan' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('tb_bahasa');
    }

    public function down()
    {
        $this->forge->dropTable('tb_bahasa');
    }
}
