<?php

namespace App\Controllers;

use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikanModel;

    public function __construct()
    {
        $this->pendidikanModel = new PendidikanModel();
    }

    public function index()
    {
        // Get query parameters
        $search = $this->request->getGet('search');
        $jenjang = $this->request->getGet('jenjang');
        $sort = $this->request->getGet('sort') ?? 'tahun_masuk';
        $order = $this->request->getGet('order') ?? 'DESC';
        $page = $this->request->getGet('page') ?? 1;

        // Build query and paginate
        $pendidikan = $this->pendidikanModel
            ->getPendidikan($search, $jenjang, $sort, $order)
            ->paginate(10, 'default', $page);
        $pager = $this->pendidikanModel->pager;

        $data = [
            'title' => 'Pendidikan',
            'pendidikan' => $pendidikan,
            'pager' => $pager,
            'search' => $search,
            'jenjang' => $jenjang,
            'sort' => $sort,
            'order' => $order,
            'jenjangList' => $this->pendidikanModel->getJenjangList(),
        ];

        return view('pendidikan/index', $data);
    }
}
