<?php

namespace App\Controllers;

use App\Models\GaleriModel;

class Galeri extends BaseController
{
    protected $galeriModel;

    public function __construct()
    {
        $this->galeriModel = new GaleriModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $tipe = $this->request->getGet('tipe');
        $page = $this->request->getGet('page') ?? 1;

        $galeri = $this->galeriModel
            ->getGaleri($search, $tipe)
            ->paginate(12, 'default', $page);
        $pager = $this->galeriModel->pager;

        $data = [
            'title' => 'Galeri',
            'galeri' => $galeri,
            'pager' => $pager,
            'search' => $search,
            'tipe' => $tipe,
        ];

        return view('galeri/index', $data);
    }
}
