<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;
use App\Models\BiodataModel;
use App\Models\PendidikanModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $aktivitasModel = new AktivitasModel();
        $biodataModel = new BiodataModel();
        $pendidikanModel = new PendidikanModel();

        $data = [
            'title' => 'Dashboard',
            'totalAktivitas' => $aktivitasModel->countAll(),
            'totalPendidikan' => $pendidikanModel->countAll(),
            'biodata' => $biodataModel->first(),
            'recentAktivitas' => $aktivitasModel->orderBy('created_at', 'DESC')->findAll(5),
        ];

        return view('admin/dashboard', $data);
    }
}
