<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class BiodataController extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        $data = [
            'title' => 'Biodata',
            'biodata' => $this->biodataModel->first(),
        ];

        return view('admin/biodata/index', $data);
    }

    public function edit()
    {
        $biodata = $this->biodataModel->first();
        
        $data = [
            'title' => 'Edit Biodata',
            'biodata' => $biodata,
        ];

        return view('admin/biodata/edit', $data);
    }

    public function update()
    {
        $rules = [
            'nama_lengkap' => 'required|min_length[3]|max_length[255]',
            'email'        => 'required|valid_email',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $biodata = $this->biodataModel->first();
        $id = $biodata ? $biodata['id'] : null;

        $data = [
            'nama_lengkap'   => $this->request->getPost('nama_lengkap'),
            'alamat'         => $this->request->getPost('alamat'),
            'email'          => $this->request->getPost('email'),
            'no_hp'          => $this->request->getPost('no_hp'),
            'deskripsi_diri' => $this->request->getPost('deskripsi_diri'),
        ];

        // Handle file upload
        $foto = $this->request->getFile('foto_profil');
        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $newName = $foto->getRandomName();
            $foto->move(FCPATH . 'uploads/biodata', $newName);
            $data['foto_profil'] = $newName;

            // Delete old photo if exists
            if ($biodata && $biodata['foto_profil'] && file_exists(FCPATH . 'uploads/biodata/' . $biodata['foto_profil'])) {
                unlink(FCPATH . 'uploads/biodata/' . $biodata['foto_profil']);
            }
        }

        if ($id) {
            $this->biodataModel->update($id, $data);
        } else {
            $this->biodataModel->insert($data);
        }

        return redirect()->to(base_url('admin/biodata'))->with('success', 'Biodata berhasil diperbarui');
    }
}
