<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Public Routes
$routes->get('/', 'Home::index');
$routes->get('biodata', 'Biodata::index');
$routes->get('pendidikan', 'Pendidikan::index');
$routes->get('aktivitas', 'Aktivitas::index');
$routes->get('aktivitas/(:num)', 'Aktivitas::detail/$1');
$routes->get('galeri', 'Galeri::index');

// Auth Routes
$routes->get('auth/login', 'Auth::login');
$routes->post('auth/login', 'Auth::attemptLogin');
$routes->get('auth/logout', 'Auth::logout');

// Admin Routes (Protected)
$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    // Dashboard
    $routes->get('/', 'Admin\Dashboard::index');
    
    // Biodata CRUD
    $routes->get('biodata', 'Admin\BiodataController::index');
    $routes->get('biodata/edit', 'Admin\BiodataController::edit');
    $routes->post('biodata/update', 'Admin\BiodataController::update');
    
    // Pendidikan CRUD
    $routes->get('pendidikan', 'Admin\PendidikanController::index');
    $routes->get('pendidikan/create', 'Admin\PendidikanController::create');
    $routes->post('pendidikan/store', 'Admin\PendidikanController::store');
    $routes->get('pendidikan/edit/(:num)', 'Admin\PendidikanController::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Admin\PendidikanController::update/$1');
    $routes->post('pendidikan/delete/(:num)', 'Admin\PendidikanController::delete/$1');
    
    // Bahasa CRUD
    $routes->get('bahasa', 'Admin\BahasaController::index');
    $routes->get('bahasa/create', 'Admin\BahasaController::create');
    $routes->post('bahasa/store', 'Admin\BahasaController::store');
    $routes->get('bahasa/edit/(:num)', 'Admin\BahasaController::edit/$1');
    $routes->post('bahasa/update/(:num)', 'Admin\BahasaController::update/$1');
    $routes->post('bahasa/delete/(:num)', 'Admin\BahasaController::delete/$1');
    
    // Sertifikat CRUD
    $routes->get('sertifikat', 'Admin\SertifikatController::index');
    $routes->get('sertifikat/create', 'Admin\SertifikatController::create');
    $routes->post('sertifikat/store', 'Admin\SertifikatController::store');
    $routes->get('sertifikat/edit/(:num)', 'Admin\SertifikatController::edit/$1');
    $routes->post('sertifikat/update/(:num)', 'Admin\SertifikatController::update/$1');
    $routes->post('sertifikat/delete/(:num)', 'Admin\SertifikatController::delete/$1');
    
    // Galeri CRUD
    $routes->get('galeri', 'Admin\GaleriController::index');
    $routes->get('galeri/create', 'Admin\GaleriController::create');
    $routes->post('galeri/store', 'Admin\GaleriController::store');
    $routes->get('galeri/edit/(:num)', 'Admin\GaleriController::edit/$1');
    $routes->post('galeri/update/(:num)', 'Admin\GaleriController::update/$1');
    $routes->post('galeri/delete/(:num)', 'Admin\GaleriController::delete/$1');
    
    // Aktivitas CRUD
    $routes->get('aktivitas', 'Admin\AktivitasController::index');
    $routes->get('aktivitas/create', 'Admin\AktivitasController::create');
    $routes->post('aktivitas/store', 'Admin\AktivitasController::store');
    $routes->get('aktivitas/edit/(:num)', 'Admin\AktivitasController::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Admin\AktivitasController::update/$1');
    $routes->post('aktivitas/delete/(:num)', 'Admin\AktivitasController::delete/$1');
});
