<?php
// Error check script
error_reporting(E_ALL);
ini_set('display_errors', 1);

$response = file_get_contents('http://localhost:8080/');

if ($response === false) {
    echo "Failed to connect!\n";
} else {
    // Check for errors
    if (preg_match('/ErrorException|DatabaseException|Error|Exception/i', $response)) {
        // Find error message
        preg_match('/<title>(.*?)<\/title>/s', $response, $title);
        preg_match('/<h1[^>]*>(.*?)<\/h1>/s', $response, $h1);
        preg_match('/class="message">(.*?)</s', $response, $msg);
        
        echo "=== ERROR FOUND ===\n";
        echo "Title: " . strip_tags($title[1] ?? 'N/A') . "\n";
        echo "H1: " . strip_tags($h1[1] ?? 'N/A') . "\n";
        echo "Message: " . strip_tags($msg[1] ?? 'N/A') . "\n";
        
        // Get more context
        if (preg_match('/pre class="source">(.*?)<\/pre>/s', $response, $source)) {
            echo "\nSource:\n" . strip_tags(html_entity_decode($source[1])) . "\n";
        }
        
        if (preg_match('/Backtrace.*?<table>(.*?)<\/table>/s', $response, $bt)) {
            echo "\nBacktrace (first 3):\n";
            preg_match_all('/<td[^>]*>(.*?)<\/td>/s', $bt[1], $rows);
            $i = 0;
            foreach ($rows[1] as $row) {
                if ($i++ > 9) break;
                echo "  " . strip_tags($row) . "\n";
            }
        }
    } else {
        echo "Page loaded successfully! Length: " . strlen($response) . " bytes\n";
        // Check for content
        if (strpos($response, 'Portfolio') !== false) {
            echo "Portfolio content found.\n";
        }
    }
}
