<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title ?? 'Admin Panel') ?></title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#8B5CF6',
                        accent: '#06B6D4',
                        success: '#10B981',
                        danger: '#F43F5E',
                        warning: '#F59E0B',
                        'dark-100': '#0F172A',
                        'dark-200': '#1E293B',
                        'dark-300': '#334155',
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'system-ui', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.min.js"></script>
    
    <style>
        body {
            background: linear-gradient(135deg, #0F172A 0%, #1E293B 50%, #0F172A 100%);
            background-attachment: fixed;
        }
        
        /* Sidebar Links */
        .sidebar-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.875rem 1rem;
            border-radius: 0.75rem;
            color: #cbd5e1;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .sidebar-link:hover {
            background: rgba(139, 92, 246, 0.15);
            color: #e2e8f0;
            transform: translateX(4px);
        }
        .sidebar-link.active {
            background: linear-gradient(135deg, #8B5CF6, #7C3AED);
            color: white;
            box-shadow: 0 4px 14px 0 rgba(139, 92, 246, 0.4);
        }
        
        /* Card Styles */
        .card {
            background: rgba(30, 41, 59, 0.8);
            border-radius: 1rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.3), 0 2px 4px -1px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(148, 163, 184, 0.15);
            transition: all 0.3s ease;
        }
        .card:hover {
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.3), 0 4px 6px -2px rgba(0, 0, 0, 0.2);
            border-color: rgba(139, 92, 246, 0.3);
        }
        
        /* Form Inputs */
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="number"],
        input[type="url"],
        input[type="date"],
        textarea,
        select {
            color: #f1f5f9 !important;
        }
        
        input::placeholder,
        textarea::placeholder {
            color: #64748b !important;
        }
        
        /* Select Dropdown Options Fix */
        select option {
            background-color: #1e293b;
            color: #f1f5f9;
            padding: 8px;
        }
        
        /* Table Styles */
        th {
            color: #f1f5f9 !important;
            font-weight: 600;
        }
        
        td {
            color: #e2e8f0 !important;
        }
        
        /* Focus Styles */
        .focus-ring:focus {
            outline: none;
            box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.3);
        }
        
        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }
        ::-webkit-scrollbar-track {
            background: rgba(51, 65, 85, 0.3);
        }
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, #8B5CF6 0%, #06B6D4 100%);
            border-radius: 3px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #8B5CF6;
        }
        
        /* Pagination */
        .pagination-btn {
            min-width: 2.5rem;
            height: 2.5rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 0.5rem;
            font-weight: 500;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }
        .pagination-btn:hover:not(.active):not(:disabled) {
            background: rgba(139, 92, 246, 0.2);
            color: #c4b5fd;
        }
        .pagination-btn.active {
            background: linear-gradient(135deg, #8B5CF6, #7C3AED);
            color: white;
            box-shadow: 0 2px 8px rgba(139, 92, 246, 0.4);
        }
        .pagination-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
    </style>
</head>
<body class="font-sans min-h-screen text-slate-200" x-data="{ sidebarOpen: false }">
    <div class="flex min-h-screen">
        <!-- Sidebar Overlay (Mobile) -->
        <div x-show="sidebarOpen" 
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             @click="sidebarOpen = false"
             class="fixed inset-0 bg-black/70 z-40 lg:hidden"></div>
        
        <!-- Sidebar -->
        <aside :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'" 
               class="fixed inset-y-0 left-0 z-50 w-64 bg-dark-200/95 backdrop-blur-xl border-r border-slate-700/50 transform transition-transform duration-300 lg:translate-x-0 lg:static">
            <div class="flex flex-col h-full">
                <!-- Logo -->
                <div class="flex items-center gap-3 px-6 py-5 border-b border-slate-700/50">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-primary to-purple-600 flex items-center justify-center text-white font-bold shadow-lg shadow-primary/30">
                        H
                    </div>
                    <div>
                        <h1 class="font-bold text-white text-lg">Hanif</h1>
                        <p class="text-xs text-slate-400">Admin Panel</p>
                    </div>
                </div>
                
                <!-- Navigation -->
                <nav class="flex-1 p-4 space-y-1 overflow-y-auto">
                    <a href="<?= base_url('admin/dashboard') ?>" class="sidebar-link <?= uri_string() === 'admin/dashboard' || uri_string() === 'admin' ? 'active' : '' ?>">
                        <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                        Dashboard
                    </a>
                    <a href="<?= base_url('admin/biodata') ?>" class="sidebar-link <?= strpos(uri_string(), 'admin/biodata') !== false ? 'active' : '' ?>">
                        <i data-lucide="user" class="w-5 h-5"></i>
                        Biodata
                    </a>
                    <a href="<?= base_url('admin/activities') ?>" class="sidebar-link <?= strpos(uri_string(), 'admin/activities') !== false ? 'active' : '' ?>">
                        <i data-lucide="folder" class="w-5 h-5"></i>
                        Aktivitas
                    </a>
                    <a href="<?= base_url('admin/educations') ?>" class="sidebar-link <?= strpos(uri_string(), 'admin/educations') !== false ? 'active' : '' ?>">
                        <i data-lucide="graduation-cap" class="w-5 h-5"></i>
                        Pendidikan
                    </a>
                    <a href="<?= base_url('admin/messages') ?>" class="sidebar-link <?= strpos(uri_string(), 'admin/messages') !== false ? 'active' : '' ?>">
                        <i data-lucide="mail" class="w-5 h-5"></i>
                        Pesan
                    </a>
                    <a href="<?= base_url('admin/settings') ?>" class="sidebar-link <?= strpos(uri_string(), 'admin/settings') !== false ? 'active' : '' ?>">
                        <i data-lucide="settings" class="w-5 h-5"></i>
                        Pengaturan
                    </a>
                </nav>
                
                <!-- Footer -->
                <div class="p-4 border-t border-slate-700/50">
                    <a href="<?= base_url('/') ?>" target="_blank" class="sidebar-link">
                        <i data-lucide="external-link" class="w-5 h-5"></i>
                        Lihat Website
                    </a>
                    <a href="<?= base_url('admin/logout') ?>" class="sidebar-link text-red-400 hover:bg-red-500/20 hover:text-red-300">
                        <i data-lucide="log-out" class="w-5 h-5"></i>
                        Logout
                    </a>
                </div>
            </div>
        </aside>
        
        <!-- Main Content -->
        <div class="flex-1 flex flex-col min-w-0">
            <!-- Top Bar -->
            <header class="bg-dark-200/80 backdrop-blur-md border-b border-slate-700/50 px-4 py-4 lg:px-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-4">
                        <button @click="sidebarOpen = true" class="lg:hidden p-2 rounded-lg hover:bg-slate-700/50 text-slate-300">
                            <i data-lucide="menu" class="w-5 h-5"></i>
                        </button>
                        <h2 class="text-xl font-bold text-white"><?= esc($title ?? 'Dashboard') ?></h2>
                    </div>
                    
                    <div class="flex items-center gap-4">
                        <span class="text-sm text-slate-300 font-medium">Halo, <span class="text-white"><?= esc(session('admin_username')) ?></span></span>
                        <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-primary/30 to-purple-600/30 flex items-center justify-center ring-2 ring-primary/30">
                            <i data-lucide="user" class="w-4 h-4 text-primary"></i>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Page Content -->
            <main class="flex-1 p-4 lg:p-6 overflow-auto">
                <!-- Flash Messages -->
                <?php if (session()->getFlashdata('success')): ?>
                <div class="mb-4 p-4 rounded-xl bg-emerald-500/15 border border-emerald-500/30 text-emerald-400 flex items-center gap-3 font-medium">
                    <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0"></i>
                    <span class="text-emerald-300"><?= session()->getFlashdata('success') ?></span>
                </div>
                <?php endif; ?>
                
                <?php if (session()->getFlashdata('error')): ?>
                <div class="mb-4 p-4 rounded-xl bg-red-500/15 border border-red-500/30 text-red-400 flex items-center gap-3 font-medium">
                    <i data-lucide="alert-circle" class="w-5 h-5 flex-shrink-0"></i>
                    <span class="text-red-300"><?= session()->getFlashdata('error') ?></span>
                </div>
                <?php endif; ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-4 p-4 rounded-xl bg-red-500/15 border border-red-500/30 text-red-400">
                    <div class="flex items-center gap-3 mb-2">
                        <i data-lucide="alert-circle" class="w-5 h-5 flex-shrink-0"></i>
                        <span class="font-semibold text-red-300">Terjadi kesalahan:</span>
                    </div>
                    <ul class="list-disc list-inside ml-8 text-sm text-red-300/90 space-y-1">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
                
                <?= $this->renderSection('content') ?>
            </main>
        </div>
    </div>
    
    <script>
        lucide.createIcons();
    </script>
    
    <?= $this->renderSection('scripts') ?>
</body>
</html>
