<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<div class="space-y-6">
    <!-- Page Header -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
        <div>
            <h1 class="text-2xl lg:text-3xl font-bold text-white">Kelola Pendidikan</h1>
            <p class="text-slate-400 mt-1">Kelola riwayat pendidikan Anda</p>
        </div>
        <a href="<?= base_url('admin/educations/create') ?>" 
           class="inline-flex items-center justify-center gap-2 px-6 py-3 rounded-xl bg-gradient-to-r from-primary to-purple-600 text-white font-semibold hover:shadow-lg hover:shadow-primary/40 transition-all duration-300 hover:-translate-y-0.5">
            <i data-lucide="plus" class="w-5 h-5"></i>
            <span>Tambah Pendidikan</span>
        </a>
    </div>
    
    <!-- Filters Card -->
    <div class="bg-slate-800/50 backdrop-blur-sm rounded-2xl border border-slate-700/50 p-4 lg:p-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <!-- Search -->
            <div class="sm:col-span-2 lg:col-span-2">
                <label class="block text-sm font-medium text-slate-300 mb-2">Cari</label>
                <div class="relative">
                    <input type="text" 
                           id="searchInput" 
                           placeholder="Cari institusi, jurusan, lokasi..." 
                           class="w-full pl-12 pr-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white placeholder-slate-500 focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all">
                    <div class="absolute left-4 top-1/2 -translate-y-1/2">
                        <i data-lucide="search" class="w-5 h-5 text-slate-500"></i>
                    </div>
                </div>
            </div>
            
            <!-- Filter Jenjang -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">Jenjang</label>
                <select id="filterDegree" 
                        class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all cursor-pointer appearance-none"
                        style="background-image: url('data:image/svg+xml;charset=UTF-8,%3csvg xmlns=%27http://www.w3.org/2000/svg%27 viewBox=%270 0 24 24%27 fill=%27none%27 stroke=%27%2394a3b8%27 stroke-width=%272%27 stroke-linecap=%27round%27 stroke-linejoin=%27round%27%3e%3cpolyline points=%276 9 12 15 18 9%27%3e%3c/polyline%3e%3c/svg%3e'); background-repeat: no-repeat; background-position: right 1rem center; background-size: 1rem;">
                    <option value="">Semua Jenjang</option>
                    <option value="SD">SD</option>
                    <option value="SMP">SMP</option>
                    <option value="SMA">SMA</option>
                    <option value="SMK">SMK</option>
                    <option value="D3">D3</option>
                    <option value="S1">S1</option>
                    <option value="S2">S2</option>
                    <option value="S3">S3</option>
                </select>
            </div>
            
            <!-- Items Per Page -->
            <div>
                <label class="block text-sm font-medium text-slate-300 mb-2">Tampilkan</label>
                <select id="itemsPerPage" 
                        class="w-full px-4 py-3 rounded-xl border border-slate-600/50 bg-slate-900/50 text-white focus:border-primary focus:ring-2 focus:ring-primary/20 outline-none transition-all cursor-pointer appearance-none"
                        style="background-image: url('data:image/svg+xml;charset=UTF-8,%3csvg xmlns=%27http://www.w3.org/2000/svg%27 viewBox=%270 0 24 24%27 fill=%27none%27 stroke=%27%2394a3b8%27 stroke-width=%272%27 stroke-linecap=%27round%27 stroke-linejoin=%27round%27%3e%3cpolyline points=%276 9 12 15 18 9%27%3e%3c/polyline%3e%3c/svg%3e'); background-repeat: no-repeat; background-position: right 1rem center; background-size: 1rem;">
                    <option value="5">5 data</option>
                    <option value="10" selected>10 data</option>
                    <option value="25">25 data</option>
                    <option value="50">50 data</option>
                </select>
            </div>
        </div>
    </div>
    
    <!-- Data Table -->
    <div class="bg-slate-800/50 backdrop-blur-sm rounded-2xl border border-slate-700/50 overflow-hidden">
        <!-- Desktop Table -->
        <div class="hidden lg:block overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-slate-700/50">
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">Institusi</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">Jenjang</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">Jurusan</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-400 uppercase tracking-wider">Periode</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-slate-400 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="tableBody" class="divide-y divide-slate-700/30">
                    <?php if (empty($educations)): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-20 text-center">
                            <div class="flex flex-col items-center">
                                <div class="w-20 h-20 rounded-2xl bg-slate-700/50 flex items-center justify-center mb-4">
                                    <i data-lucide="graduation-cap" class="w-10 h-10 text-slate-500"></i>
                                </div>
                                <h3 class="text-lg font-semibold text-slate-300 mb-1">Belum ada data pendidikan</h3>
                                <p class="text-slate-500 text-sm mb-4">Mulai tambahkan riwayat pendidikan Anda</p>
                                <a href="<?= base_url('admin/educations/create') ?>" 
                                   class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-primary/20 text-primary hover:bg-primary/30 transition-colors text-sm font-medium">
                                    <i data-lucide="plus" class="w-4 h-4"></i>
                                    Tambah Pendidikan
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php else: ?>
                    <?php foreach ($educations as $edu): ?>
                    <tr class="hover:bg-slate-700/20 transition-colors data-row" 
                        data-degree="<?= esc($edu['degree'] ?? '') ?>" 
                        data-search="<?= strtolower(esc($edu['institution'] . ' ' . ($edu['major'] ?? '') . ' ' . ($edu['location'] ?? '') . ' ' . ($edu['degree'] ?? ''))) ?>">
                        <td class="px-6 py-5">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center flex-shrink-0 ring-1 ring-slate-600/50">
                                    <?php if (!empty($edu['logo'])): ?>
                                    <img src="<?= media_url($edu['logo']) ?>" alt="" class="w-full h-full object-contain rounded-xl p-1">
                                    <?php else: ?>
                                    <i data-lucide="building-2" class="w-6 h-6 text-primary"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="min-w-0">
                                    <h4 class="text-white font-semibold truncate"><?= esc($edu['institution']) ?></h4>
                                    <?php if (!empty($edu['location'])): ?>
                                    <p class="text-slate-400 text-sm flex items-center gap-1 mt-0.5">
                                        <i data-lucide="map-pin" class="w-3.5 h-3.5 flex-shrink-0"></i>
                                        <span class="truncate"><?= esc($edu['location']) ?></span>
                                    </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-5">
                            <?php if (!empty($edu['degree'])): ?>
                            <span class="inline-flex items-center px-3 py-1.5 rounded-lg text-sm font-semibold
                                <?php 
                                $degreeColor = match($edu['degree'] ?? '') {
                                    'S3' => 'bg-purple-500/20 text-purple-400 ring-1 ring-purple-500/30',
                                    'S2' => 'bg-blue-500/20 text-blue-400 ring-1 ring-blue-500/30',
                                    'S1' => 'bg-cyan-500/20 text-cyan-400 ring-1 ring-cyan-500/30',
                                    'D3' => 'bg-teal-500/20 text-teal-400 ring-1 ring-teal-500/30',
                                    'SMA', 'SMK' => 'bg-green-500/20 text-green-400 ring-1 ring-green-500/30',
                                    'SMP' => 'bg-yellow-500/20 text-yellow-400 ring-1 ring-yellow-500/30',
                                    'SD' => 'bg-orange-500/20 text-orange-400 ring-1 ring-orange-500/30',
                                    default => 'bg-slate-500/20 text-slate-400 ring-1 ring-slate-500/30',
                                };
                                echo $degreeColor;
                                ?>">
                                <?= esc($edu['degree']) ?>
                            </span>
                            <?php else: ?>
                            <span class="text-slate-500">-</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-5">
                            <span class="text-slate-300"><?= esc($edu['major'] ?? '-') ?></span>
                        </td>
                        <td class="px-6 py-5">
                            <span class="text-slate-300 font-medium">
                                <?= esc($edu['start_year'] ?? '-') ?> 
                                <span class="text-slate-500">-</span> 
                                <?= esc($edu['end_year'] ?? 'Sekarang') ?>
                            </span>
                        </td>
                        <td class="px-6 py-5">
                            <div class="flex items-center justify-end gap-1">
                                <a href="<?= base_url('admin/educations/edit/' . $edu['id']) ?>" 
                                   class="p-2.5 rounded-lg hover:bg-primary/20 text-slate-400 hover:text-primary transition-all" 
                                   title="Edit">
                                    <i data-lucide="pencil" class="w-4 h-4"></i>
                                </a>
                                <form action="<?= base_url('admin/educations/delete/' . $edu['id']) ?>" method="post" 
                                      onsubmit="return confirm('Yakin ingin menghapus pendidikan ini?')">
                                    <?= csrf_field() ?>
                                    <button type="submit" 
                                            class="p-2.5 rounded-lg hover:bg-red-500/20 text-slate-400 hover:text-red-400 transition-all" 
                                            title="Hapus">
                                        <i data-lucide="trash-2" class="w-4 h-4"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Mobile Cards -->
        <div class="lg:hidden divide-y divide-slate-700/30" id="mobileCards">
            <?php if (empty($educations)): ?>
            <div class="px-6 py-16 text-center">
                <div class="flex flex-col items-center">
                    <div class="w-16 h-16 rounded-2xl bg-slate-700/50 flex items-center justify-center mb-4">
                        <i data-lucide="graduation-cap" class="w-8 h-8 text-slate-500"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-slate-300 mb-1">Belum ada data</h3>
                    <p class="text-slate-500 text-sm">Tambahkan pendidikan Anda</p>
                </div>
            </div>
            <?php else: ?>
            <?php foreach ($educations as $edu): ?>
            <div class="p-4 hover:bg-slate-700/20 transition-colors data-row-mobile"
                 data-degree="<?= esc($edu['degree'] ?? '') ?>" 
                 data-search="<?= strtolower(esc($edu['institution'] . ' ' . ($edu['major'] ?? '') . ' ' . ($edu['location'] ?? '') . ' ' . ($edu['degree'] ?? ''))) ?>">
                <div class="flex items-start gap-4">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-primary/20 to-accent/20 flex items-center justify-center flex-shrink-0">
                        <i data-lucide="building-2" class="w-6 h-6 text-primary"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-start justify-between gap-2">
                            <div>
                                <h4 class="text-white font-semibold"><?= esc($edu['institution']) ?></h4>
                                <?php if (!empty($edu['degree'])): ?>
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-semibold mt-1
                                    <?php 
                                    $degreeColor = match($edu['degree'] ?? '') {
                                        'S3' => 'bg-purple-500/20 text-purple-400',
                                        'S2' => 'bg-blue-500/20 text-blue-400',
                                        'S1' => 'bg-cyan-500/20 text-cyan-400',
                                        'D3' => 'bg-teal-500/20 text-teal-400',
                                        'SMA', 'SMK' => 'bg-green-500/20 text-green-400',
                                        'SMP' => 'bg-yellow-500/20 text-yellow-400',
                                        'SD' => 'bg-orange-500/20 text-orange-400',
                                        default => 'bg-slate-500/20 text-slate-400',
                                    };
                                    echo $degreeColor;
                                    ?>">
                                    <?= esc($edu['degree']) ?>
                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="flex items-center gap-1 flex-shrink-0">
                                <a href="<?= base_url('admin/educations/edit/' . $edu['id']) ?>" 
                                   class="p-2 rounded-lg hover:bg-primary/20 text-slate-400 hover:text-primary transition-all">
                                    <i data-lucide="pencil" class="w-4 h-4"></i>
                                </a>
                                <form action="<?= base_url('admin/educations/delete/' . $edu['id']) ?>" method="post" 
                                      onsubmit="return confirm('Yakin ingin menghapus?')">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="p-2 rounded-lg hover:bg-red-500/20 text-slate-400 hover:text-red-400 transition-all">
                                        <i data-lucide="trash-2" class="w-4 h-4"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                        <div class="mt-2 space-y-1 text-sm">
                            <?php if (!empty($edu['major'])): ?>
                            <p class="text-slate-400"><?= esc($edu['major']) ?></p>
                            <?php endif; ?>
                            <div class="flex items-center gap-4 text-slate-500">
                                <span class="flex items-center gap-1">
                                    <i data-lucide="calendar" class="w-3.5 h-3.5"></i>
                                    <?= esc($edu['start_year'] ?? '-') ?> - <?= esc($edu['end_year'] ?? 'Sekarang') ?>
                                </span>
                                <?php if (!empty($edu['location'])): ?>
                                <span class="flex items-center gap-1">
                                    <i data-lucide="map-pin" class="w-3.5 h-3.5"></i>
                                    <?= esc($edu['location']) ?>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <!-- No Results -->
        <div id="noResults" class="hidden px-6 py-16 text-center">
            <div class="flex flex-col items-center">
                <div class="w-16 h-16 rounded-2xl bg-slate-700/50 flex items-center justify-center mb-4">
                    <i data-lucide="search-x" class="w-8 h-8 text-slate-500"></i>
                </div>
                <h3 class="text-lg font-semibold text-slate-300 mb-1">Tidak ada hasil</h3>
                <p class="text-slate-500 text-sm">Coba kata kunci lain atau ubah filter</p>
            </div>
        </div>
        
        <!-- Pagination Footer -->
        <div class="px-4 lg:px-6 py-4 border-t border-slate-700/50 flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="text-sm text-slate-400">
                Menampilkan <span id="showingStart" class="font-semibold text-white">0</span> - <span id="showingEnd" class="font-semibold text-white">0</span> dari <span id="totalItems" class="font-semibold text-white">0</span> data
            </div>
            <div id="paginationButtons" class="flex items-center gap-1 flex-wrap justify-center">
                <!-- Pagination buttons inserted by JS -->
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // State
    let currentPage = 1;
    let itemsPerPage = 10;
    let filteredRows = [];
    
    // DOM Elements
    const searchInput = document.getElementById('searchInput');
    const filterDegree = document.getElementById('filterDegree');
    const itemsPerPageSelect = document.getElementById('itemsPerPage');
    const tableBody = document.getElementById('tableBody');
    const mobileCards = document.getElementById('mobileCards');
    const noResults = document.getElementById('noResults');
    const paginationButtons = document.getElementById('paginationButtons');
    const showingStart = document.getElementById('showingStart');
    const showingEnd = document.getElementById('showingEnd');
    const totalItems = document.getElementById('totalItems');
    
    // Get all rows (desktop and mobile)
    const allDesktopRows = Array.from(tableBody?.querySelectorAll('tr.data-row') || []);
    const allMobileRows = Array.from(mobileCards?.querySelectorAll('.data-row-mobile') || []);
    
    function filterTable() {
        const searchTerm = searchInput.value.toLowerCase();
        const selectedDegree = filterDegree.value;
        
        // Filter desktop rows
        filteredRows = allDesktopRows.filter(row => {
            const searchData = row.getAttribute('data-search');
            const degreeData = row.getAttribute('data-degree');
            
            const matchesSearch = searchData.includes(searchTerm);
            const matchesDegree = !selectedDegree || degreeData === selectedDegree;
            
            return matchesSearch && matchesDegree;
        });
        
        // Also filter mobile rows
        allMobileRows.forEach(row => {
            const searchData = row.getAttribute('data-search');
            const degreeData = row.getAttribute('data-degree');
            
            const matchesSearch = searchData.includes(searchTerm);
            const matchesDegree = !selectedDegree || degreeData === selectedDegree;
            
            row.style.display = (matchesSearch && matchesDegree) ? '' : 'none';
        });
        
        currentPage = 1;
        renderTable();
    }
    
    function renderTable() {
        const totalFiltered = filteredRows.length;
        const totalPages = Math.ceil(totalFiltered / itemsPerPage);
        const startIndex = (currentPage - 1) * itemsPerPage;
        const endIndex = Math.min(startIndex + itemsPerPage, totalFiltered);
        
        // Hide all desktop rows
        allDesktopRows.forEach(row => row.style.display = 'none');
        
        // Show rows for current page
        for (let i = startIndex; i < endIndex; i++) {
            filteredRows[i].style.display = '';
        }
        
        // Update info
        showingStart.textContent = totalFiltered > 0 ? startIndex + 1 : 0;
        showingEnd.textContent = endIndex;
        totalItems.textContent = totalFiltered;
        
        // No results
        const hasData = allDesktopRows.length > 0 || allMobileRows.length > 0;
        if (totalFiltered === 0 && hasData) {
            noResults.classList.remove('hidden');
        } else {
            noResults.classList.add('hidden');
        }
        
        renderPagination(totalPages);
    }
    
    function renderPagination(totalPages) {
        paginationButtons.innerHTML = '';
        
        if (totalPages <= 1) return;
        
        // Previous
        const prevBtn = createPaginationBtn('chevron-left', currentPage > 1);
        prevBtn.onclick = () => currentPage > 1 && goToPage(currentPage - 1);
        paginationButtons.appendChild(prevBtn);
        
        // Page numbers
        const maxVisible = window.innerWidth < 640 ? 3 : 5;
        let startPage = Math.max(1, currentPage - Math.floor(maxVisible / 2));
        let endPage = Math.min(totalPages, startPage + maxVisible - 1);
        
        if (endPage - startPage + 1 < maxVisible) {
            startPage = Math.max(1, endPage - maxVisible + 1);
        }
        
        if (startPage > 1) {
            paginationButtons.appendChild(createPageBtn(1));
            if (startPage > 2) {
                const dots = document.createElement('span');
                dots.className = 'px-2 text-slate-600';
                dots.textContent = '...';
                paginationButtons.appendChild(dots);
            }
        }
        
        for (let i = startPage; i <= endPage; i++) {
            paginationButtons.appendChild(createPageBtn(i, i === currentPage));
        }
        
        if (endPage < totalPages) {
            if (endPage < totalPages - 1) {
                const dots = document.createElement('span');
                dots.className = 'px-2 text-slate-600';
                dots.textContent = '...';
                paginationButtons.appendChild(dots);
            }
            paginationButtons.appendChild(createPageBtn(totalPages));
        }
        
        // Next
        const nextBtn = createPaginationBtn('chevron-right', currentPage < totalPages);
        nextBtn.onclick = () => currentPage < totalPages && goToPage(currentPage + 1);
        paginationButtons.appendChild(nextBtn);
        
        lucide.createIcons();
    }
    
    function createPaginationBtn(icon, enabled) {
        const btn = document.createElement('button');
        btn.className = `w-9 h-9 flex items-center justify-center rounded-lg transition-all ${enabled ? 'text-slate-300 hover:bg-slate-700' : 'text-slate-600 cursor-not-allowed'}`;
        btn.innerHTML = `<i data-lucide="${icon}" class="w-4 h-4"></i>`;
        btn.disabled = !enabled;
        return btn;
    }
    
    function createPageBtn(page, isActive = false) {
        const btn = document.createElement('button');
        btn.className = `min-w-[2.25rem] h-9 px-3 flex items-center justify-center rounded-lg font-medium text-sm transition-all ${isActive ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-slate-300 hover:bg-slate-700'}`;
        btn.textContent = page;
        btn.onclick = () => goToPage(page);
        return btn;
    }
    
    function goToPage(page) {
        currentPage = page;
        renderTable();
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
    
    // Event listeners
    searchInput?.addEventListener('input', filterTable);
    filterDegree?.addEventListener('change', filterTable);
    itemsPerPageSelect?.addEventListener('change', (e) => {
        itemsPerPage = parseInt(e.target.value);
        currentPage = 1;
        filterTable();
    });
    
    // Initialize
    filteredRows = [...allDesktopRows];
    renderTable();
    lucide.createIcons();
</script>
<?= $this->endSection() ?>
