<?php

namespace App\Models;

use CodeIgniter\Model;

class SettingsModel extends Model
{
    protected $table            = 'settings';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['setting_key', 'value'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = '';
    protected $updatedField  = 'updated_at';

    /**
     * Get setting value by key
     */
    public function get(string $key, $default = null)
    {
        $setting = $this->where('setting_key', $key)->first();
        return $setting ? $setting['value'] : $default;
    }

    /**
     * Set setting value
     */
    public function setSetting(string $key, $value): bool
    {
        $existing = $this->where('setting_key', $key)->first();
        
        if ($existing) {
            return $this->update($existing['id'], ['value' => $value]);
        }
        
        return $this->insert(['setting_key' => $key, 'value' => $value]) !== false;
    }

    /**
     * Get all settings as key-value array
     */
    public function getAllSettings(): array
    {
        $settings = [];
        foreach ($this->findAll() as $setting) {
            $settings[$setting['setting_key']] = $setting['value'];
        }
        return $settings;
    }
}
