<?php

namespace App\Models;

use CodeIgniter\Model;

class EducationModel extends Model
{
    protected $table            = 'educations';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'institution', 'degree', 'major', 'start_year', 'end_year', 
        'description', 'location', 'logo'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'institution' => 'required|max_length[255]',
        'start_year'  => 'permit_empty|exact_length[4]|numeric',
        'end_year'    => 'permit_empty|exact_length[4]|numeric',
    ];

    protected $validationMessages = [
        'institution' => [
            'required' => 'Nama institusi wajib diisi.',
        ],
    ];

    /**
     * Get all educations ordered by start year
     */
    public function getAllOrdered(): array
    {
        return $this->orderBy('start_year', 'DESC')->findAll();
    }
}
