<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AdminAuthFilter implements FilterInterface
{
    /**
     * Check if admin is logged in before accessing protected routes
     */
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();
        
        // Check if admin is logged in
        if (!$session->get('admin_logged_in')) {
            // Store intended URL for redirect after login
            $session->set('redirect_url', current_url());
            
            return redirect()->to('/admin/login')->with('error', 'Silakan login terlebih dahulu.');
        }
        
        return null;
    }

    /**
     * Do nothing after the controller
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        return null;
    }
}
