<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class BiodataSeeder extends Seeder
{
    public function run()
    {
        $data = [
            'name'     => 'Hanif Developer',
            'headline' => 'Full-Stack Developer & UI/UX Designer',
            'summary'  => 'Saya adalah seorang pengembang web yang berpengalaman dengan passion dalam menciptakan pengalaman digital yang luar biasa. Dengan keahlian di berbagai teknologi modern, saya membantu bisnis mengembangkan solusi web yang inovatif dan user-friendly.',
            'photo'    => null,
            'email'    => 'hanif@example.com',
            'phone'    => '+62 812 3456 7890',
            'location' => 'Jakarta, Indonesia',
            'socials_json' => json_encode([
                'github'   => 'https://github.com/hanif',
                'linkedin' => 'https://linkedin.com/in/hanif',
                'twitter'  => 'https://twitter.com/hanif',
                'instagram' => 'https://instagram.com/hanif',
            ]),
            'skills_json' => json_encode([
                ['name' => 'PHP', 'level' => 90],
                ['name' => 'JavaScript', 'level' => 85],
                ['name' => 'CodeIgniter', 'level' => 90],
                ['name' => 'Laravel', 'level' => 80],
                ['name' => 'Vue.js', 'level' => 75],
                ['name' => 'React', 'level' => 70],
                ['name' => 'MySQL', 'level' => 85],
                ['name' => 'UI/UX Design', 'level' => 80],
            ]),
            'tools_json' => json_encode([
                'VS Code', 'Git', 'Docker', 'Figma', 
                'Postman', 'MySQL Workbench', 'Terminal',
                'Photoshop', 'Illustrator'
            ]),
            'cv_file'    => null,
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        $this->db->table('biodata')->insert($data);
    }
}
