<?php

namespace App\Controllers;

use App\Models\BiodataModel;
use App\Models\SettingsModel;

class BiodataController extends BaseController
{
    protected $biodataModel;
    protected $settingsModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        $this->settingsModel = new SettingsModel();
        helper('media');
    }

    public function index()
    {
        $biodata = $this->biodataModel->getBiodata();
        $settings = $this->settingsModel->getAllSettings();

        $data = [
            'title'       => 'Biodata - ' . ($settings['site_title'] ?? 'Portfolio'),
            'description' => 'Profil lengkap ' . ($biodata['name'] ?? ''),
            'biodata'     => $biodata,
            'settings'    => $settings,
        ];

        return view('public/biodata', $data);
    }
}
