<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class BiodataAdminController extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
        helper('media');
    }

    public function edit()
    {
        $biodata = $this->biodataModel->getBiodata();

        $data = [
            'title'   => 'Edit Biodata',
            'biodata' => $biodata,
        ];

        return view('admin/biodata/edit', $data);
    }

    public function update()
    {
        $rules = [
            'name'  => 'required|max_length[255]',
            'email' => 'permit_empty|valid_email',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        // Prepare data
        $data = [
            'name'     => $this->request->getPost('name'),
            'headline' => $this->request->getPost('headline'),
            'summary'  => $this->request->getPost('summary'),
            'email'    => $this->request->getPost('email'),
            'phone'    => $this->request->getPost('phone'),
            'location' => $this->request->getPost('location'),
        ];

        // Handle socials
        $socials = [
            'github'    => $this->request->getPost('github'),
            'linkedin'  => $this->request->getPost('linkedin'),
            'twitter'   => $this->request->getPost('twitter'),
            'instagram' => $this->request->getPost('instagram'),
        ];
        $data['socials'] = array_filter($socials);

        // Handle skills
        $skillsRaw = $this->request->getPost('skills');
        if ($skillsRaw) {
            $skillsArr = [];
            foreach ($skillsRaw as $skill) {
                if (!empty($skill['name'])) {
                    $skillsArr[] = [
                        'name'  => $skill['name'],
                        'level' => (int)($skill['level'] ?? 50),
                    ];
                }
            }
            $data['skills'] = $skillsArr;
        }

        // Handle tools
        $toolsRaw = $this->request->getPost('tools');
        if ($toolsRaw) {
            $data['tools'] = array_filter(array_map('trim', explode(',', $toolsRaw)));
        }

        // Handle photo upload
        $photo = $this->request->getFile('photo');
        if ($photo && $photo->isValid() && !$photo->hasMoved()) {
            $newPhoto = upload_media($photo, 'profile');
            if ($newPhoto) {
                // Delete old photo
                $oldBiodata = $this->biodataModel->getBiodata();
                if (!empty($oldBiodata['photo'])) {
                    delete_media($oldBiodata['photo']);
                }
                $data['photo'] = $newPhoto;
            }
        }

        // Handle CV upload
        $cv = $this->request->getFile('cv_file');
        if ($cv && $cv->isValid() && !$cv->hasMoved()) {
            $newCv = upload_media($cv, 'cv');
            if ($newCv) {
                $oldBiodata = $this->biodataModel->getBiodata();
                if (!empty($oldBiodata['cv_file'])) {
                    delete_media($oldBiodata['cv_file']);
                }
                $data['cv_file'] = $newCv;
            }
        }

        if ($this->biodataModel->saveBiodata($data)) {
            return redirect()->to('/admin/biodata')->with('success', 'Biodata berhasil diperbarui!');
        }

        return redirect()->back()->withInput()->with('error', 'Gagal memperbarui biodata.');
    }
}
