<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<?php
    $hasPagination = !empty($pager)
        && method_exists($pager, 'getPageCount')
        && $pager->getPageCount('default') > 1;
?>

<div class="page-header">
    <h1 class="page-title">Riwayat Pendidikan</h1>
    <p style="color: var(--text-dim);">Perjalanan akademis dan kualifikasi pendidikan.</p>
</div>

<?php if ($hasPagination): ?>
    <div aria-label="Navigasi halaman pendidikan" style="margin: 1.5rem 0; display: flex; justify-content: center;">
        <?= $pager->links('default', 'default_full') ?>
    </div>
<?php endif; ?>

<div class="container" style="max-width: 1200px; margin: 0 auto; padding-bottom: 4rem;">
    
    <!-- Filter (Optional, keeping it simple for now or adding if needed) -->
    <!-- For simplicity in Education, we might just show the list, but maintaining the filter if user wants it -->
    <div class="filter-container">
         <form class="filter-form" method="get" action="<?= base_url('pendidikan') ?>">
            <div class="form-group">
                <label>Cari Institusi/Jurusan</label>
                <input type="text" name="q" class="form-control" value="<?= esc($search ?? '') ?>" placeholder="Cari...">
            </div>
            <div class="form-group">
                <label>Jenjang</label>
                <select name="jenjang" class="form-control">
                    <option value="">Semua</option>
                    <option value="SD" <?= ($jenjang ?? '') === 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= ($jenjang ?? '') === 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA/K" <?= ($jenjang ?? '') === 'SMA/K' ? 'selected' : '' ?>>SMA/K</option>
                    <option value="S1" <?= ($jenjang ?? '') === 'S1' ? 'selected' : '' ?>>S1</option>
                </select>
            </div>
            <div class="form-group" style="flex: 0 0 auto;">
                <button type="submit" class="btn-primary" style="border:none; cursor:pointer;">Filter</button>
            </div>
        </form>
    </div>

    <!-- Grid Layout -->
    <?php if (!empty($pendidikan) && is_array($pendidikan) && count($pendidikan) > 0): ?>
        <div class="horizontal-cards" style="margin-top: 2.5rem;">
            <?php foreach ($pendidikan as $item): ?>
                <div class="feature-card">
                    <div class="feature-card-body">
                        <span class="activity-date"><?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></span>
                        <h3><?= esc($item['institusi']) ?></h3>
                        <p style="margin: 0.2rem 0; color: var(--text-light); font-weight: 600;"><?= esc($item['jenjang']) ?></p>
                        <p class="muted" style="margin: 0;"><?= esc($item['jurusan']) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div style="text-align: center; color: var(--text-dim); padding: 2rem;">
            <p>Tidak ada data pendidikan ditemukan.</p>
        </div>
    <?php endif; ?>

    <!-- Pagination -->
    <?php if ($hasPagination): ?>
        <div aria-label="Navigasi halaman pendidikan" style="margin-top: 4rem; display: flex; justify-content: center;">
            <?= $pager->links('default', 'default_full') ?>
        </div>
    <?php endif; ?>

</div>

<?= $this->endSection() ?>
