<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Portfolio Digital' ?></title>
    <!-- Favicon -->
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="<?= base_url('css/style.css?v=' . time()) ?>">
</head>
<body style="--bg-image: url('<?= base_url('uploads/15022e6e99f21eaf653b694f7762f160.jpg') ?>');">
    <!-- Navigation -->
    <nav class="main-nav">
        <div>
            <div class="nav-brand"></div>
            <ul>
                <li><a href="<?= base_url() ?>" class="<?= url_is('/') ? 'active' : '' ?>">Dashboard</a></li>
                <li><a href="<?= base_url('cv') ?>" class="<?= url_is('cv') ? 'active' : '' ?>">Biodata</a></li>
                <li><a href="<?= base_url('pendidikan') ?>" class="<?= url_is('pendidikan') ? 'active' : '' ?>">Pendidikan</a></li>
                <li><a href="<?= base_url('aktivitas') ?>" class="<?= url_is('aktivitas') ? 'active' : '' ?>">Aktivitas</a></li>
            </ul>
            <button class="mobile-menu-btn">Menu</button>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer>
        <div>
            <div>
                <div>
                    <a href="https://wa.me/qr/RWH4IF6FL46XH1" target="_blank" rel="noopener">WhatsApp</a>
                </div>
                <div>
                    <a href="https://www.instagram.com/furqonismee?igsh=MXN5bTRmMDRkdTl3OQ==" target="_blank" rel="noopener">Instagram</a>
                </div>
                <div>
                    <a href="-" target="_blank" rel="noopener">Twitter</a>
                </div>
                <div>
                    <a href="-" target="_blank" rel="noopener">LinkedIn</a>
                </div>
                <div>
                    <a href="-" target="_blank" rel="noopener">GitHub</a>
                </div>
                <div>
                    <a href="-" target="_blank" rel="noopener">YouTube</a>
                </div>
            </div>
            <p>&copy; <?= date('Y') ?> Furqonisme | Portfolio Digital | 2025</p>
        </div>
    </footer>

    <!-- Mobile Menu Handler -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuBtn = document.querySelector('.main-nav .mobile-menu-btn');
            const navLinks = document.querySelector('.main-nav ul');
            if (mobileMenuBtn && navLinks) {
                mobileMenuBtn.addEventListener('click', function() {
                    navLinks.classList.toggle('open');
                });
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
