<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Admin Panel' ?></title>
    <!-- Favicon -->
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">
</head>
<body>
    <!-- Navigation -->
    <nav>
        <div>
            <div class="nav-brand">
                <a href="<?= base_url('admin') ?>">Dashboard</a>
            </div>
            <ul>
                <li><a href="<?= base_url('admin') ?>">Dashboard</a></li>
                <li><a href="<?= base_url('admin/biodata') ?>">Biodata</a></li>
                <li><a href="<?= base_url('admin/pendidikan') ?>">Pendidikan</a></li>
                <li><a href="<?= base_url('admin/aktivitas') ?>">Aktivitas</a></li>
                <li><a href="<?= base_url('admin/logout') ?>">Logout</a></li>
            </ul>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?php if (session()->getFlashdata('success')): ?>
            <div>
                <p><?= esc(session()->getFlashdata('success')) ?></p>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div>
                <p><?= esc(session()->getFlashdata('error')) ?></p>
            </div>
        <?php endif; ?>

        <?= $this->renderSection('content') ?>
    </main>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
