<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<?php
    $biodata   = $biodata ?? null;
    $photoPath = $biodata['foto'] ?? '';
    $photoUrl  = $photoPath ? base_url($photoPath) : 'https://via.placeholder.com/400';
?>

<!-- Hero Section -->
<section class="home-hero">
    <div class="hero-left">
        <p class="eyebrow">Portfolio</p>
        <h1>Halo, Saya <?= esc($biodata['nama'] ?? 'Daniel') ?></h1>
        <p class="muted">Temukan perjalanan, karya, dan pengalaman saya. Jelajahi pendidikan, aktivitas, dan profil lengkap.</p>
        <div class="hero-cta">
            <a href="<?= base_url('admin/login') ?>" class="btn-primary">Login</a>
        </div>
    </div>
    <div class="hero-mosaic">
        <?php
            $galleryItems = $gallery ?? [];
            $mosaicSlots = 4;
        ?>
        <?php for ($i = 0; $i < $mosaicSlots; $i++): ?>
            <?php $g = $galleryItems[$i] ?? null; ?>
            <div class="<?= $i === 0 ? 'mosaic-large' : ($i === 2 ? 'mosaic-tall' : 'mosaic-small') ?>"
                 style="<?php if ($g): ?>background-image: url('<?= base_url($g['image_path']) ?>'); background-size: cover; background-position: center;<?php endif; ?>"></div>
        <?php endfor; ?>
    </div>
</section>

<!-- Highlight Section (About) -->
<section id="about" class="section-padding home-highlight">
    <div class="section-head">
        <div>
            <p class="eyebrow">Profil</p>
            <h2 class="section-title">Tentang Saya</h2>
        </div>
        <a href="<?= base_url('cv') ?>" class="btn-ghost">Lihat CV Lengkap</a>
    </div>
    <div class="about-grid">
        <div class="about-img">
            <img src="<?= $photoUrl ?>" alt="<?= esc($biodata['nama'] ?? 'Profile') ?>">
        </div>
        <div class="about-info">
            <p><?= nl2br(esc($biodata['tentang'] ?? 'Deskripsi diri belum ditambahkan.')) ?></p>
            
            <div class="info-list">
                <div class="info-item">
                    <span class="info-label">Email:</span>
                    <span><?= esc($biodata['email'] ?? '-') ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Telepon:</span>
                    <span><?= esc($biodata['telepon'] ?? '-') ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Alamat:</span>
                    <span><?= esc($biodata['alamat'] ?? '-') ?></span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Pendidikan preview -->
<section id="education" class="section-padding home-section-light">
    <div class="section-head">
        <div>
            <p class="eyebrow">Pendidikan</p>
            <h2 class="section-title">Riwayat Pendidikan</h2>
        </div>
        <a class="btn-ghost" href="<?= base_url('pendidikan') ?>">Lihat semua</a>
    </div>
    <div class="horizontal-cards">
        <?php if (!empty($pendidikan) && is_array($pendidikan)): ?>
            <?php foreach ($pendidikan as $edu): ?>
                <div class="feature-card">
                    <div class="feature-card-body">
                        <span class="activity-date"><?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?></span>
                        <h3><?= esc($edu['institusi']) ?></h3>
                        <p><?= esc($edu['jenjang']) ?> · <?= esc($edu['jurusan']) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="muted" style="text-align:center; width:100%;">Data pendidikan belum tersedia.</p>
        <?php endif; ?>
    </div>
</section>

<!-- Aktivitas preview -->
<section id="activities" class="section-padding">
    <div class="section-head">
        <div>
            <p class="eyebrow">Aktivitas</p>
            <h2 class="section-title">Aktivitas Terbaru</h2>
        </div>
        <a class="btn-ghost" href="<?= base_url('aktivitas') ?>">Lihat semua</a>
    </div>
    <div class="stories-grid">
        <?php if (!empty($latestAktivitas) && is_array($latestAktivitas)): ?>
            <?php foreach ($latestAktivitas as $item): ?>
                <?php $mediaUrl = !empty($item['file_path']) ? base_url(ltrim($item['file_path'], '/')) : 'https://via.placeholder.com/400x250?text=Activity'; ?>
                <div class="story-card">
                    <div class="story-thumb" style="background-image: url('<?= esc($mediaUrl) ?>'); background-size: cover; background-position: center;"></div>
                    <div class="story-body">
                        <span class="activity-date"><?= date('d M Y', strtotime($item['tanggal'])) ?></span>
                        <h3><?= esc($item['nama_aktivitas']) ?></h3>
                        <p><?= substr(esc($item['deskripsi']), 0, 110) ?>...</p>
                        <a href="<?= base_url('aktivitas/' . $item['id']) ?>" class="story-link">Baca Selengkapnya</a>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="muted" style="text-align:center; width:100%;">Belum ada aktivitas terbaru.</p>
        <?php endif; ?>
    </div>
</section>

<!-- Gallery preview -->
<section id="gallery" class="section-padding home-section-light">
    <div class="section-head">
        <div>
            <p class="eyebrow">Gallery</p>
            <h2 class="section-title">Koleksi Foto</h2>
        </div>
        <!-- Refresh button removed per request -->
    </div>
    <div class="gallery-grid">
        <?php if (!empty($gallery)): ?>
            <?php foreach ($gallery as $item): ?>
                <div class="gallery-card">
                    <div class="gallery-thumb" style="background-image: url('<?= base_url($item['image_path']) ?>'); background-size: cover; background-position: center;"></div>
                    <div class="gallery-meta">
                        <h4><?= esc($item['title']) ?></h4>
                        <?php if (!empty($item['description'])): ?>
                            <p class="muted"><?= esc($item['description']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="admin-empty" style="background:none; border:1px solid var(--glass-border);">
                <p class="muted">Belum ada foto di gallery.</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection() ?>
