<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<?php
    $photoPath = $biodata['foto'] ?? '';
    $photoUrl  = $photoPath ? base_url(ltrim($photoPath, '/')) : 'https://via.placeholder.com/150';
    $skills    = array_filter(array_map('trim', preg_split('/[,\\n]+/', $biodata['keahlian'] ?? '')));
?>

<div class="page-header" style="padding-bottom: 2rem;">
    <h1 class="page-title">Curriculum Vitae</h1>
    <div style="margin-top: 1rem;">
        <button onclick="window.print()" class="btn-primary" style="border:none; cursor:pointer;">Cetak PDF / Print</button>
    </div>
</div>

<div class="container cv-card">
    <!-- Header -->
    <div style="display:flex; gap:1.5rem; align-items:center; margin-bottom:1.5rem; border-bottom:1px solid #ddd; padding-bottom:1.25rem;">
        <div style="width: 150px; height: 150px; background: #eee; border-radius: 50%; overflow: hidden; flex-shrink: 0;">
            <img src="<?= esc($photoUrl) ?>" alt="Foto" style="width: 100%; height: 100%; object-fit: cover;">
        </div>
        <div>
            <h1 style="margin:0; font-size:2.4rem; color:#111;"><?= esc($biodata['nama'] ?? 'Nama Lengkap') ?></h1>
            <p style="margin:0.4rem 0 0; font-size:1.2rem; color:#444;"><?= esc($biodata['status'] ?? 'Professional') ?></p>
        </div>
    </div>

    <!-- Konten -->
    <div style="display: grid; gap: 1.25rem;">
        <section>
            <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px;">Profil Singkat</h2>
            <p style="line-height:1.6; margin:0; color:#444;"><?= nl2br(esc($biodata['tentang'] ?? 'Deskripsi profil belum ditambahkan.')) ?></p>
        </section>

        <section>
            <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px;">Identitas</h2>
            <div style="display:grid; gap:0.35rem; color:#444; font-size:0.95rem;">
                <div><strong>Tempat / Tanggal Lahir:</strong> <?= esc($biodata['tempat_lahir'] ?? '-') ?>, <?= esc($biodata['tanggal_lahir'] ?? '-') ?></div>
                <div><strong>Alamat:</strong> &#128205; <?= esc($biodata['alamat'] ?? '-') ?></div>
                <div><strong>Agama:</strong> <?= esc($biodata['agama'] ?? '-') ?></div>
                <div><strong>Kewarganegaraan:</strong> <?= esc($biodata['kewarganegaraan'] ?? '-') ?></div>
                <div><strong>Status Pernikahan:</strong> <?= esc($biodata['status_pernikahan'] ?? '-') ?></div>
                <div><strong>Golongan Darah:</strong> <?= esc($biodata['golongan_darah'] ?? '-') ?></div>
            </div>
        </section>

        <section>
            <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px;">Kontak</h2>
            <div style="display:grid; gap:0.35rem; color:#444; font-size:0.95rem;">
                <div><strong>Email:</strong> &#9993; <?= esc($biodata['email'] ?? '-') ?></div>
                <div><strong>Telepon:</strong> &#9742; <?= esc($biodata['telepon'] ?? '-') ?></div>
                <?php if (!empty($biodata['linkedin']) || !empty($biodata['github'])): ?>
                    <div style="display:flex; gap:0.8rem; flex-wrap:wrap;">
                        <?php if (!empty($biodata['linkedin'])): ?>
                            <span><a href="<?= esc($biodata['linkedin']) ?>" target="_blank" rel="noopener">LinkedIn</a></span>
                        <?php endif; ?>
                        <?php if (!empty($biodata['github'])): ?>
                            <span><a href="<?= esc($biodata['github']) ?>" target="_blank" rel="noopener">GitHub</a></span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>

        <?php if (!empty($skills) || !empty($biodata['keahlian'])): ?>
        <section>
            <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px;">Keahlian</h2>
            <?php if (!empty($skills)): ?>
                <ul style="margin:0; padding-left:1.2rem; color:#444; line-height:1.6;">
                    <?php foreach ($skills as $skill): ?>
                        <li><?= esc($skill) ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p style="line-height:1.6; margin:0; color:#444;"><?= nl2br(esc($biodata['keahlian'])) ?></p>
            <?php endif; ?>
        </section>
        <?php endif; ?>

        <?php if (!empty($biodata['pengalaman'])): ?>
        <section>
            <h2 style="border-bottom:1px solid #ccc; padding-bottom:0.35rem; margin:0 0 0.75rem; text-transform: uppercase; font-size:1.05rem; letter-spacing:0.5px;">Pengalaman</h2>
            <p style="line-height:1.6; margin:0; color:#444;"><?= nl2br(esc($biodata['pengalaman'])) ?></p>
        </section>
        <?php endif; ?>
    </div>
</div>

<style>
    .cv-card {
        max-width: 900px;
        margin: 0 auto;
        padding: 2rem;
        background: white;
        color: #333;
        border-radius: 10px;
        margin-bottom: 4rem;
        box-shadow: 0 10px 30px rgba(0,0,0,0.12);
    }
    .cv-card h1, .cv-card h2 {
        color: #111;
    }
    .cv-card p, .cv-card li, .cv-card div {
        color: #444;
    }
    .cv-card a {
        color: #2563eb;
    }
    .cv-card a:hover {
        color: #1e40af;
    }
    .cv-card hr, .cv-card h2 {
        border-color: #ccc;
    }

    @media print {
        body { background: white; color: black; }
        nav, footer, .page-header button { display: none; }
        .page-header { padding: 0; text-align: left; }
        .page-title { display: none; }
        .container { margin: 0; padding: 0; box-shadow: none; border: none; width: 100%; max-width: 100%; }
    }
</style>

<?= $this->endSection() ?>
