<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<div class="page-header">
    <h1 class="page-title">Biodata</h1>
    <p style="color: var(--text-dim);">Daftar biodata yang tersedia dalam database.</p>
</div>

<div class="container" style="max-width: 1200px; margin: 0 auto; padding-bottom: 4rem;">
    <!-- Filter Section -->
    <div class="filter-container">
        <form class="filter-form" method="get" action="<?= base_url('biodata') ?>">
            <div class="form-group">
                <label>Cari</label>
                <input type="text" name="q" class="form-control" value="<?= esc($search ?? '') ?>" placeholder="Nama, email, atau alamat...">
            </div>
            <div class="form-group">
                <label>Jenis Kelamin</label>
                <select name="jk" class="form-control">
                    <option value="">Semua</option>
                    <option value="Laki-laki" <?= ($jk ?? '') === 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= ($jk ?? '') === 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control">
                    <option value="">Semua</option>
                    <option value="Mahasiswa" <?= ($status ?? '') === 'Mahasiswa' ? 'selected' : '' ?>>Mahasiswa</option>
                    <option value="Alumni" <?= ($status ?? '') === 'Alumni' ? 'selected' : '' ?>>Alumni</option>
                </select>
            </div>
            <div class="form-group">
                <label>Urutkan</label>
                <select name="sort" class="form-control">
                    <option value="nama_asc" <?= ($sort ?? '') === 'nama_asc' ? 'selected' : '' ?>>Nama A-Z</option>
                    <option value="nama_desc" <?= ($sort ?? '') === 'nama_desc' ? 'selected' : '' ?>>Nama Z-A</option>
                </select>
            </div>
            <div class="form-group" style="flex: 0 0 auto;">
                <button type="submit" class="btn-primary" style="border:none; cursor:pointer;">Terapkan</button>
            </div>
        </form>
    </div>

    <!-- Grid Layout -->
    <div class="card-grid">
        <?php if (!empty($biodata)): ?>
            <?php foreach ($biodata as $item): ?>
                <div class="card">
                    <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1.5rem;">
                        <div style="width: 60px; height: 60px; background: #333; border-radius: 50%; overflow: hidden;">
                            <?php 
                                $photoPath = $item['foto'] ?? '';
                                $photoUrl = $photoPath ? base_url($photoPath) : 'https://via.placeholder.com/150';
                            ?>
                            <img src="<?= $photoUrl ?>" alt="Foto" style="width: 100%; height: 100%; object-fit: cover;">
                        </div>
                        <div>
                            <h3 style="margin: 0; color: var(--text-light);"><?= esc($item['nama']) ?></h3>
                            <span style="color: var(--primary-color); font-size: 0.9rem;"><?= esc($item['status'] ?? 'Mahasiswa') ?></span>
                        </div>
                    </div>
                    
                    <div class="card-text">
                        <div style="display: flex; gap: 0.5rem; margin-bottom: 0.5rem;">
                            <span style="color: var(--text-dim); width: 20px;">📧</span>
                            <span><?= esc($item['email']) ?></span>
                        </div>
                        <div style="display: flex; gap: 0.5rem; margin-bottom: 0.5rem;">
                            <span style="color: var(--text-dim); width: 20px;">📱</span>
                            <span><?= esc($item['telepon']) ?></span>
                        </div>
                        <div style="display: flex; gap: 0.5rem;">
                            <span style="color: var(--text-dim); width: 20px;">📍</span>
                            <span><?= esc($item['alamat']) ?></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="grid-column: 1 / -1; text-align: center; padding: 4rem; color: var(--text-dim);">
                <p>Tidak ada data biodata yang ditemukan.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if (!empty($pager)): ?>
        <div style="margin-top: 2rem;">
            <?= $pager->links() ?>
        </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>
