<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<section>
    <h1>Aktivitas</h1>
    
    <?php if (isset($aktivitas) && count($aktivitas) > 0): ?>
        <div>
            <?php foreach ($aktivitas as $item): ?>
                <div>
                    <h3><?= esc($item['judul']) ?></h3>
                    <p><?= nl2br(esc($item['deskripsi'] ?? '')) ?></p>
                    <small>Tanggal: <?= esc($item['tanggal'] ?? '') ?></small>
                    <?php if (isset($item['id'])): ?>
                        <br>
                        <a href="<?= base_url('aktivitas/' . $item['id']) ?>">Lihat Detail</a>
                    <?php endif; ?>
                </div>
                <hr>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p>Tidak ada data aktivitas</p>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
