<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section>
    <h1>Pendidikan</h1>
    <a href="<?= base_url('admin/pendidikan/create') ?>">Tambah Pendidikan</a>

    <?php if (isset($pendidikan) && count($pendidikan) > 0): ?>
        <table border="1" cellpadding="10">
            <thead>
                <tr>
                    <th>Institusi</th>
                    <th>Jenjang</th>
                    <th>Jurusan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pendidikan as $item): ?>
                    <tr>
                        <td><?= esc($item['institusi']) ?></td>
                        <td><?= esc($item['jenjang']) ?></td>
                        <td><?= esc($item['jurusan']) ?></td>
                        <td>
                            <a href="<?= base_url('admin/pendidikan/edit/' . $item['id']) ?>">Edit</a>
                            <form method="post" action="<?= base_url('admin/pendidikan/delete/' . $item['id']) ?>" style="display:inline;">
                                <button type="submit" onclick="return confirm('Yakin?');">Hapus</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Tidak ada data pendidikan</p>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
