<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Pendidikan</p>
            <h1 style="margin:0;">Kelola Pendidikan</h1>
        </div>
        <a class="btn-primary" href="<?= base_url('admin/pendidikan/create') ?>">Tambah Pendidikan</a>
    </div>

    <?php if (isset($pendidikan) && count($pendidikan) > 0): ?>
        <div class="horizontal-cards">
            <?php foreach ($pendidikan as $item): ?>
                <div class="feature-card">
                    <div class="feature-card-body" style="display:grid; gap:0.35rem;">
                        <span class="activity-date"><?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></span>
                        <h3><?= esc($item['institusi']) ?></h3>
                        <p style="margin:0; color: var(--text-light); font-weight: 600;"><?= esc($item['jenjang']) ?></p>
                        <p class="muted" style="margin:0;"><?= esc($item['jurusan']) ?></p>
                        <div class="action-links" style="margin-top: 0.5rem;">
                            <a class="chip-link" href="<?= base_url('admin/pendidikan/edit/' . $item['id']) ?>">Edit</a>
                            <form method="post" action="<?= base_url('admin/pendidikan/delete/' . $item['id']) ?>" onsubmit="return confirm('Yakin hapus data ini?');">
                                <?= csrf_field() ?>
                                <button class="chip-link danger" type="submit">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="admin-empty">
            <p class="muted">Tidak ada data pendidikan</p>
        </div>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
