<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="auth-wrapper">
    <div class="auth-card">
        <h1>Login Admin</h1>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <strong>Error:</strong> <?= esc(session()->getFlashdata('error')) ?>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <?= esc(session()->getFlashdata('success')) ?>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('admin/login') ?>" method="POST" class="form-stacked">
            <?= csrf_field() ?>

            <div class="form-group">
                <label for="username">Username</label>
                <input
                    type="text"
                    id="username"
                    name="username"
                    class="form-control"
                    placeholder="Masukkan username"
                    value="<?= esc(old('username')) ?>"
                    autocomplete="username"
                    autofocus
                    required
                >
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <div class="password-wrapper">
                    <input
                        type="password"
                        id="password"
                        name="password"
                        class="form-control"
                        placeholder="Masukkan password"
                        autocomplete="current-password"
                        required
                    >
                    <button
                        type="button"
                        class="toggle-password"
                        aria-pressed="false"
                        aria-label="Tampilkan password"
                        onclick="togglePassword()"
                    >
                        <svg class="icon-eye-open" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="display:block;">
                            <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7Z"/>
                            <circle cx="12" cy="12" r="3"/>
                        </svg>
                        <svg class="icon-eye-closed" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="display:none;">
                            <path d="M3 3l18 18"/>
                            <path d="M10.584 10.59a2 2 0 0 0 2.828 2.828"/>
                            <path d="M9.88 4.14A10.24 10.24 0 0 1 12 4c7 0 11 8 11 8a14.6 14.6 0 0 1-2.243 3.362"/>
                            <path d="M6.61 6.613C3.978 8.266 2 12 2 12a14.57 14.57 0 0 0 5.09 5.08"/>
                        </svg>
                    </button>
                </div>
            </div>

            <button type="submit" class="btn-primary full-width" style="margin-top: 10px;">Login</button>
        </form>

        <div class="footer-links">
            <a href="<?= base_url() ?>">Kembali ke Halaman Utama</a>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const toggleBtn = document.querySelector('.toggle-password');
        const eyeOpen = toggleBtn.querySelector('.icon-eye-open');
        const eyeClosed = toggleBtn.querySelector('.icon-eye-closed');
        const isHidden = passwordInput.type === 'password';

        passwordInput.type = isHidden ? 'text' : 'password';
        toggleBtn.setAttribute('aria-pressed', isHidden ? 'true' : 'false');
        toggleBtn.setAttribute('aria-label', isHidden ? 'Sembunyikan password' : 'Tampilkan password');

        if (eyeOpen && eyeClosed) {
            eyeOpen.style.display = isHidden ? 'none' : 'block';
            eyeClosed.style.display = isHidden ? 'block' : 'none';
        }
    }
</script>
<?= $this->endSection() ?>
