<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-dashboard">
    <div class="admin-hero">
        <div class="admin-hero-left">
            <p class="eyebrow">Admin Dashboard</p>
            <h1>Ringkasan Portfolio</h1>
            <p class="muted">Pantau data biodata, riwayat pendidikan, dan aktivitas terbaru.</p>
            <div class="hero-cta">
                <?php if (session()->get('admin_logged_in')): ?>
                    <a class="btn-primary" href="<?= base_url('admin/logout') ?>">Logout</a>
                <?php endif; ?>
            </div>
        </div>
        <div class="admin-hero-stats">
            <div class="mini-stat">
                <span class="stat-label">Biodata</span>
                <span class="stat-value"><?= esc($biodata_count ?? 0) ?></span>
                <small class="stat-meta">Update: <?= esc($latest_times['biodata'] ?? '-') ?></small>
            </div>
            <div class="mini-stat">
                <span class="stat-label">Pendidikan</span>
                <span class="stat-value"><?= esc($pendidikan_count ?? 0) ?></span>
                <small class="stat-meta">Update: <?= esc($latest_times['pendidikan'] ?? '-') ?></small>
            </div>
            <div class="mini-stat">
                <span class="stat-label">Aktivitas</span>
                <span class="stat-value"><?= esc($aktivitas_count ?? 0) ?></span>
                <small class="stat-meta">Update: <?= esc($latest_times['aktivitas'] ?? '-') ?></small>
            </div>
        </div>
    </div>

    <div class="admin-gallery">
        <div class="section-head">
            <div>
                <p class="eyebrow">Gallery</p>
                <h2 class="section-title">Koleksi Foto</h2>
                <p class="muted" style="margin:0;">Gunakan area ini untuk menampilkan foto-foto yang akan diposting nanti.</p>
            </div>
            <a class="btn-ghost" href="<?= base_url('admin/gallery') ?>">Kelola Gallery</a>
        </div>
        <div class="gallery-grid">
            <?php if (!empty($gallery)): ?>
                <?php foreach ($gallery as $item): ?>
                    <div class="gallery-card">
                        <div class="gallery-thumb" style="background-image: url('<?= base_url($item['image_path']) ?>'); background-size: cover; background-position: center;"></div>
                        <div class="gallery-meta">
                            <h4><?= esc($item['title']) ?></h4>
                            <?php if (!empty($item['description'])): ?>
                                <p class="muted"><?= esc($item['description']) ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="admin-empty">
                    <p class="muted">Belum ada foto. Tambahkan melalui halaman Kelola Gallery.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="admin-quick-links">
        <div>
            <h3>Quick Links</h3>
            <p class="muted">Akses cepat ke halaman pengelolaan.</p>
        </div>
        <div class="quick-link-chips">
            <a class="chip-link" href="<?= base_url('admin/biodata/create') ?>">Tambah Biodata</a>
            <a class="chip-link" href="<?= base_url('admin/pendidikan/create') ?>">Tambah Pendidikan</a>
            <a class="chip-link" href="<?= base_url('admin/aktivitas/create') ?>">Tambah Aktivitas</a>
        </div>
    </div>
</section>

<?= $this->endSection() ?>
