<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<?php
    $item = $biodata ?? [];
    $foto = $item['foto'] ?? '';
    $fotoUrl = $foto ? base_url(ltrim($foto, '/')) : 'https://via.placeholder.com/240';
    $skills = !empty($item['keahlian'])
        ? array_filter(array_map('trim', preg_split('/[,\\n]+/', $item['keahlian'])))
        : [];
?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Data Personal</p>
            <h1 style="margin: 0;">Detail Biodata</h1>
            <p class="muted" style="margin: 0;">Pratinjau tampilan biodata publik.</p>
        </div>
        <div class="admin-header-actions">
            <a class="btn-ghost" href="<?= base_url('admin/biodata') ?>">Kembali</a>
            <a class="btn-primary" href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>">Edit</a>
        </div>
    </div>

    <div class="admin-profile-card resemble-public">
        <header class="public-bio-header">
            <div class="public-bio-photo">
                <img src="<?= esc($fotoUrl) ?>" alt="Foto" loading="lazy">
            </div>
            <div class="public-bio-heading">
                <h1><?= esc($item['nama'] ?? '-') ?></h1>
                <div class="public-bio-meta">
                    <span><?= esc($item['email'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span><?= esc($item['telepon'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span><?= esc($item['alamat'] ?? '-') ?></span>
                </div>
                <div class="public-bio-meta">
                    <span><?= esc($item['tempat_lahir'] ?? '-') ?>, <?= esc($item['tanggal_lahir'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span><?= esc($item['agama'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span><?= esc($item['kewarganegaraan'] ?? '-') ?></span>
                </div>
                <div class="public-bio-meta">
                    <span>Status: <?= esc($item['status'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span>Pernikahan: <?= esc($item['status_pernikahan'] ?? '-') ?></span>
                    <span>&#183;</span>
                    <span>Gol. Darah: <?= esc($item['golongan_darah'] ?? '-') ?></span>
                </div>
                <?php if (!empty($item['linkedin']) || !empty($item['github'])): ?>
                    <div class="public-bio-meta">
                        <?php if (!empty($item['linkedin'])): ?>
                            <span><a href="<?= esc($item['linkedin']) ?>" target="_blank" rel="noopener">LinkedIn</a></span>
                        <?php endif; ?>
                        <?php if (!empty($item['linkedin']) && !empty($item['github'])): ?>
                            <span>&#183;</span>
                        <?php endif; ?>
                        <?php if (!empty($item['github'])): ?>
                            <span><a href="<?= esc($item['github']) ?>" target="_blank" rel="noopener">GitHub</a></span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </header>

        <hr class="divider">

        <section class="public-bio-section">
            <h3>Profil</h3>
            <p><?= nl2br(esc($item['tentang'] ?? 'Belum ada profil.')) ?></p>
        </section>

        <?php if (!empty($skills)): ?>
            <section class="public-bio-section">
                <h3>Keahlian</h3>
                <div class="pill-row">
                    <?php foreach ($skills as $skill): ?>
                        <span class="pill"><?= esc($skill) ?></span>
                    <?php endforeach; ?>
                </div>
            </section>
        <?php endif; ?>

        <?php if (!empty($item['pengalaman'])): ?>
            <section class="public-bio-section">
                <h3>Pengalaman</h3>
                <p><?= nl2br(esc($item['pengalaman'])) ?></p>
            </section>
        <?php endif; ?>

        <section class="public-bio-section">
            <h3>Status / Identitas</h3>
            <p class="muted">
                <?= esc($item['status'] ?? '-') ?> | Pernikahan: <?= esc($item['status_pernikahan'] ?? '-') ?> | Gol. Darah: <?= esc($item['golongan_darah'] ?? '-') ?>
            </p>
        </section>
    </div>
</section>
<?= $this->endSection() ?>
