<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<section class="admin-section">
    <div class="admin-section-header">
        <div>
            <p class="eyebrow">Aktivitas</p>
            <h1 style="margin:0;">Kelola Aktivitas</h1>
        </div>
        <a class="btn-primary" href="<?= base_url('admin/aktivitas/create') ?>">Tambah Aktivitas</a>
    </div>

    <?php if (isset($aktivitas) && count($aktivitas) > 0): ?>
        <div class="activities-grid">
            <?php foreach ($aktivitas as $item): ?>
                <?php $mediaUrl = !empty($item['file_path']) ? base_url(ltrim($item['file_path'], '/')) : 'https://via.placeholder.com/400x300?text=Activity'; ?>
                <div class="activity-card" style="display:flex; flex-direction:column; height:100%;">
                    <div class="activity-img">
                        <img src="<?= esc($mediaUrl) ?>" alt="<?= esc($item['judul'] ?? $item['nama_aktivitas'] ?? 'Aktivitas') ?>" style="width:100%; height:100%; object-fit:cover;">
                    </div>
                    <div class="activity-info" style="display:flex; flex-direction:column; flex:1;">
                        <span class="activity-date"><?= date('d M Y', strtotime($item['tanggal'] ?? $item['date'] ?? 'now')) ?></span>
                        <h3 style="margin-top:0.5rem; color:var(--text-light);">
                            <?= esc($item['judul'] ?? $item['nama_aktivitas'] ?? 'Judul Aktivitas') ?>
                        </h3>
                        <p style="color: var(--text-dim); flex-grow:1; margin-bottom:1rem;">
                            <?= substr(strip_tags($item['deskripsi'] ?? $item['description'] ?? ''), 0, 100) ?>...
                        </p>
                        <div class="action-links" style="margin-top:auto;">
                            <a class="chip-link" href="<?= base_url('admin/aktivitas/edit/' . $item['id']) ?>">Edit</a>
                            <form method="post" action="<?= base_url('admin/aktivitas/delete/' . $item['id']) ?>" onsubmit="return confirm('Yakin hapus aktivitas ini?');">
                                <?= csrf_field() ?>
                                <button class="chip-link danger" type="submit">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="admin-empty">
            <p class="muted">Tidak ada data aktivitas</p>
        </div>
    <?php endif; ?>
</section>

<?= $this->endSection() ?>
