<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddIdentityFieldsToBiodata extends Migration
{
    public function up()
    {
        $fields = [
            'tempat_lahir' => [
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => true,
                'after' => 'nama',
            ],
            'tanggal_lahir' => [
                'type' => 'DATE',
                'null' => true,
                'after' => 'tempat_lahir',
            ],
            'agama' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
                'after' => 'tanggal_lahir',
            ],
            'kewarganegaraan' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
                'after' => 'agama',
            ],
            'status_pernikahan' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => true,
                'after' => 'status',
            ],
            'golongan_darah' => [
                'type' => 'VARCHAR',
                'constraint' => 3,
                'null' => true,
                'after' => 'status_pernikahan',
            ],
            'linkedin' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'pengalaman',
            ],
            'github' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'linkedin',
            ],
        ];

        $this->forge->addColumn('biodata', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('biodata', [
            'tempat_lahir',
            'tanggal_lahir',
            'agama',
            'kewarganegaraan',
            'status_pernikahan',
            'golongan_darah',
            'linkedin',
            'github',
        ]);
    }
}
