<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Frontend Routes
$routes->get('/', 'Home::index');
$routes->get('cv', 'Home::cv');
$routes->get('biodata', 'Home::biodata_list');
$routes->get('pendidikan', 'Home::pendidikan');
$routes->get('aktivitas', 'Home::aktivitas');
$routes->get('aktivitas/(:num)', 'Home::aktivitas_detail/$1');

// Backend Routes
$routes->group('admin', function($routes) {
    $routes->get('login', 'Admin::login');
    $routes->post('login', 'Admin::login');
    $routes->get('logout', 'Admin::logout');
    
    $routes->get('/', 'Admin::index');
    
    // Biodata CRUD
    $routes->get('biodata', 'Admin::biodata');
    $routes->get('biodata/create', 'Admin::biodata_create');
    $routes->post('biodata/create', 'Admin::biodata_create');
    $routes->get('biodata/detail/(:num)', 'Admin::biodata_detail/$1');
    $routes->get('biodata/edit/(:num)', 'Admin::biodata_edit/$1');
    $routes->post('biodata/edit/(:num)', 'Admin::biodata_edit/$1');
    $routes->post('biodata/delete/(:num)', 'Admin::biodata_delete/$1');
    
    // Pendidikan CRUD
    $routes->get('pendidikan', 'Admin::pendidikan');
    $routes->get('pendidikan/create', 'Admin::pendidikan_create');
    $routes->post('pendidikan/create', 'Admin::pendidikan_create');
    $routes->get('pendidikan/edit/(:num)', 'Admin::pendidikan_edit/$1');
    $routes->post('pendidikan/edit/(:num)', 'Admin::pendidikan_edit/$1');
    $routes->post('pendidikan/delete/(:num)', 'Admin::pendidikan_delete/$1');
    
    // Aktivitas CRUD
    $routes->get('aktivitas', 'Admin::aktivitas');
    $routes->get('aktivitas/create', 'Admin::aktivitas_create');
    $routes->post('aktivitas/create', 'Admin::aktivitas_create');
    $routes->get('aktivitas/edit/(:num)', 'Admin::aktivitas_edit/$1');
    $routes->post('aktivitas/edit/(:num)', 'Admin::aktivitas_edit/$1');
    $routes->post('aktivitas/delete/(:num)', 'Admin::aktivitas_delete/$1');

    // Gallery
    $routes->get('gallery', 'Admin::gallery');
    $routes->post('gallery', 'Admin::gallery');
    $routes->post('gallery/delete/(:num)', 'Admin::gallery_delete/$1');
});
