﻿<?php
    $brandColor = \App\Models\StoreSetting::getValue('store.brand_color', '#F7BFA0');
    $brandName = \App\Models\StoreSetting::getValue('store.name', "D'Shop");
    $brandLogo = \App\Models\StoreSetting::getValue('store.logo', 'assets/logo-dshop.png');
    $brandLogoUrl = (!empty($brandLogo) && !preg_match('/^(https?:)?\/\//', $brandLogo) && ! str_starts_with($brandLogo, 'data:'))
        ? asset($brandLogo)
        : $brandLogo;
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', "D'Shop")); ?></title>

        <link rel="icon" type="image/png" href="<?php echo e($brandLogoUrl); ?>">
        <link rel="shortcut icon" href="<?php echo e($brandLogoUrl); ?>" type="image/png">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="font-[Poppins] text-slate-800 antialiased bg-gradient-to-br from-[#FFF7F2] via-white to-[#FFF7F2]">
        <div class="min-h-screen flex flex-col items-center justify-center px-4 py-8 sm:px-6 lg:px-8">
            <a href="<?php echo e(route('home')); ?>" class="mb-8 flex flex-col items-center gap-2 text-center">
                <?php if(!empty($brandLogoUrl)): ?>
                    <img src="<?php echo e($brandLogoUrl); ?>" alt="<?php echo e($brandName); ?> Logo" class="h-16 w-16 rounded-full border border-[#FAD4C2] object-cover shadow-lg transition hover:scale-105">
                <?php else: ?>
                    <span class="inline-flex h-14 w-14 items-center justify-center rounded-full text-xl font-semibold text-white shadow-lg transition hover:scale-105" style="background-color: <?php echo e($brandColor); ?>;">
                        <?php echo e(\Illuminate\Support\Str::of($brandName)->substr(0, 2)->upper()); ?>

                    </span>
                <?php endif; ?>
                <span class="text-base font-semibold text-slate-900"><?php echo e($brandName); ?></span>
            </a>

            <div class="w-full max-w-md rounded-2xl border border-[#FAD4C2] bg-white shadow-xl shadow-orange-100/40 px-6 py-6">
                <?php echo e($slot); ?>

            </div>
        </div>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\web\dshop\resources\views/layouts/guest.blade.php ENDPATH**/ ?>