﻿<?php
$basePath = dirname(__DIR__) . '/resources/data';
if (!is_dir($basePath)) {
    mkdir($basePath, 0777, true);
}

$provincesUrl = 'https://www.emsifa.com/api-wilayah-indonesia/api/provinces.json';
$provincesJson = file_get_contents($provincesUrl);
if ($provincesJson === false) {
    fwrite(STDERR, "Failed to download provinces data\n");
    exit(1);
}

$provinces = json_decode($provincesJson, true);
if (!is_array($provinces)) {
    fwrite(STDERR, "Invalid provinces payload\n");
    exit(1);
}

file_put_contents($basePath . '/rajaongkir_provinces.json', json_encode($provinces, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

$cities = [];
foreach ($provinces as $province) {
    $provinceId = $province['id'];
    $provinceName = ucwords(strtolower($province['name']));
    $regenciesUrl = "https://www.emsifa.com/api-wilayah-indonesia/api/regencies/{$provinceId}.json";
    $regenciesJson = file_get_contents($regenciesUrl);

    if ($regenciesJson === false) {
        fwrite(STDERR, "Failed to fetch regencies for province {$provinceId}\n");
        continue;
    }

    $regencies = json_decode($regenciesJson, true);
    if (!is_array($regencies)) {
        fwrite(STDERR, "Invalid regencies payload for province {$provinceId}\n");
        continue;
    }

    foreach ($regencies as $regency) {
        $rawName = trim($regency['name']);
        $type = stripos($rawName, 'KOTA') === 0 ? 'Kota' : 'Kabupaten';
        $cityName = preg_replace('/^(KABUPATEN|KOTA)\s+/i', '', $rawName);

        $cities[] = [
            'city_id' => (int) $regency['id'],
            'province_id' => (int) $provinceId,
            'province' => $provinceName,
            'type' => $type,
            'city_name' => ucwords(strtolower($cityName)),
            'postal_code' => null,
            'source' => 'offline-cache',
        ];
    }
}

file_put_contents($basePath . '/rajaongkir_cities.json', json_encode($cities, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
echo "Saved " . count($cities) . " offline cities" . PHP_EOL;
