﻿<?php

use App\Http\Controllers\Admin\AdminCategoryController;
use App\Http\Controllers\Admin\AdminCustomerController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\AdminIncomeController;
use App\Http\Controllers\Admin\AdminOrderController;
use App\Http\Controllers\Admin\AdminProductController;
use App\Http\Controllers\Admin\AdminSettingController;
use App\Http\Controllers\Account\AddressController;
use App\Http\Controllers\Account\NotificationController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\Cashier\CashierDashboardController;
use App\Http\Controllers\Cashier\CashierOrderController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LandingController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ShippingController;
use App\Http\Controllers\ReviewController;
use Illuminate\Support\Facades\Route;

Route::get('/', LandingController::class)->name('home');

Route::get('/catalog', [ProductController::class, 'index'])->name('products.index');
Route::get('/products/{product:slug}', [ProductController::class, 'show'])->name('products.show');

Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart', [CartController::class, 'store'])->name('cart.store');
Route::post('/cart/buy-now', [CartController::class, 'buyNow'])->name('cart.buy-now');
Route::patch('/cart/items/{cartItem}', [CartController::class, 'update'])->name('cart.items.update');
Route::delete('/cart/items/{cartItem}', [CartController::class, 'destroy'])->name('cart.items.destroy');
Route::post('/cart/selection', [CartController::class, 'updateSelection'])->name('cart.selection.update');

// Shipping (public API for checkout)
Route::prefix('api/shipping')->name('shipping.')->group(function () {
    Route::get('provinces', [ShippingController::class, 'provinces'])->name('provinces');
    Route::get('cities', [ShippingController::class, 'cities'])->name('cities');
    Route::get('search-city', [ShippingController::class, 'searchCity'])->name('search-city');
    Route::post('calculate-cost', [ShippingController::class, 'calculateCost'])->name('calculate-cost');
});

// Customer routes (default web guard). Allow order detail also for admin/kasir guards.
Route::middleware(['auth:web', 'verified'])->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('dashboard');

    Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout.index');
    Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout.store');

    Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Akun - Alamat
    Route::prefix('account')->name('account.')->group(function () {
        Route::get('notifications', [NotificationController::class, 'index'])->name('notifications');
        Route::get('addresses', [AddressController::class, 'index'])->name('addresses');
        Route::post('addresses', [AddressController::class, 'store'])->name('addresses.store');
        Route::put('addresses/{address}', [AddressController::class, 'update'])->name('addresses.update');
        Route::delete('addresses/{address}', [AddressController::class, 'destroy'])->name('addresses.destroy');
    });
});

// Order detail/payment/print: izinkan web, admin, atau kasir guard.
Route::middleware(['auth:web,admin,cashier'])->group(function () {
    Route::get('/orders/{order}', [OrderController::class, 'show'])->name('orders.show');
    Route::get('/orders/{order}/print', [OrderController::class, 'print'])->name('orders.print');
    Route::get('/orders/{order}/payment', [CheckoutController::class, 'payment'])->name('orders.payment');
    Route::post('/orders/{order}/cancel', [OrderController::class, 'cancel'])->name('orders.cancel');

    // Produk - Ulasan
    Route::post('/products/{product}/reviews', [ReviewController::class, 'store'])->name('products.reviews.store');
    Route::delete('/reviews/{review}', [ReviewController::class, 'destroy'])->name('reviews.destroy');
});

Route::prefix('admin')
    ->name('admin.')
    ->middleware(['auth:admin', 'role:admin'])
    ->group(function () {
        Route::get('/', AdminDashboardController::class)->name('dashboard');
        Route::match(['get', 'post'], 'logout', [\App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'destroy'])->name('logout');

        Route::resource('products', AdminProductController::class);
        Route::resource('categories', AdminCategoryController::class)->except(['show']);

        Route::get('income', [AdminIncomeController::class, 'index'])->name('income.index');
        Route::get('income/export', [AdminIncomeController::class, 'export'])->name('income.export');
        
        // Orders routes
        Route::get('orders', [AdminOrderController::class, 'index'])->name('orders.index');
        Route::get('orders/{order}', [AdminOrderController::class, 'show'])->name('orders.detail');
        Route::get('orders/{order}/print', [AdminOrderController::class, 'print'])->name('orders.print');
        Route::patch('orders/{order}/status', [AdminOrderController::class, 'updateStatus'])->name('orders.update-status');
        Route::patch('orders/{order}/ship', [AdminOrderController::class, 'shipOrder'])->name('orders.ship');
        
        Route::get('customers', [AdminCustomerController::class, 'index'])->name('customers.index');
        Route::get('settings', [AdminSettingController::class, 'index'])->name('settings.index');
        Route::patch('settings', [AdminSettingController::class, 'update'])->name('settings.update');
        Route::patch('settings/password', [AdminSettingController::class, 'updatePassword'])->name('settings.password');
    });

Route::prefix('kasir')
    ->name('cashier.')
    ->middleware(['auth:admin,cashier', 'role:cashier,admin'])
    ->group(function () {
        Route::get('/', CashierDashboardController::class)->name('dashboard');
        Route::match(['get', 'post'], 'logout', [\App\Http\Controllers\Auth\AuthenticatedSessionController::class, 'destroy'])->name('logout');

        Route::get('orders/create', [CashierOrderController::class, 'create'])->name('orders.create');
        Route::post('orders', [CashierOrderController::class, 'store'])->name('orders.store');
        Route::get('orders/{order}', [CashierOrderController::class, 'show'])->name('orders.detail');
        Route::post('orders/{order}/mark-paid', [CashierOrderController::class, 'markPaid'])->name('orders.markPaid');
        Route::get('orders/{order}/print', [CashierOrderController::class, 'print'])->name('orders.print');
    });

require __DIR__ . '/auth.php';
