<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col gap-3 md:flex-row md:items-end md:justify-between">
            <div>
                <p class="text-xs font-semibold uppercase tracking-wide text-[#C26A3D]/80 dark:text-amber-400/80">Jelajahi Koleksi Kami</p>
                <h1 class="text-2xl font-bold text-slate-900 dark:text-white">Katalog Produk 🛍️</h1>
                <p class="text-sm text-slate-500 dark:text-slate-400 mt-1">Fashion, kecantikan, parfum, dan perlengkapan UMKM terbaik.</p>
            </div>
            <div class="flex items-center gap-3">
                <span class="inline-flex items-center gap-2 rounded-full bg-gradient-to-r from-[#FFE2CF] to-[#FFDDF5] dark:from-amber-900/30 dark:to-pink-900/30 px-4 py-2 text-sm font-semibold text-[#C26A3D] dark:text-amber-300">
                    <span class="flex h-2 w-2 rounded-full bg-[#C26A3D] dark:bg-amber-400 animate-pulse"></span>
                    {{ $products->total() }} produk tersedia
                </span>
            </div>
        </div>
    </x-slot>

    <section class="py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
            {{-- Search & Filter Section --}}
            <div class="rounded-3xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm">
                <form method="GET" action="{{ route('products.index') }}" class="space-y-5">
                    {{-- Search Bar --}}
                    <div class="flex flex-col sm:flex-row gap-3">
                        <div class="relative flex-1">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <svg class="h-5 w-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                            <input type="text" name="search" value="{{ $search }}" 
                                placeholder="Cari produk, merek, atau kata kunci..." 
                                class="w-full pl-11 pr-4 py-3 rounded-xl border-2 border-[#FAD4C2]/60 dark:border-slate-700 bg-[#FFF8F3] dark:bg-slate-800 text-slate-900 dark:text-white placeholder-slate-400 text-sm focus:border-[#C26A3D] dark:focus:border-amber-500 focus:ring-2 focus:ring-orange-200 dark:focus:ring-amber-900/50 transition" />
                        </div>
                        <button type="submit" class="inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 py-3 text-sm font-semibold text-white shadow-md hover:shadow-lg transition transform hover:scale-[1.02]">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                            Cari
                        </button>
                    </div>
                    
                    {{-- Category Pills --}}
                    <div class="space-y-3">
                        <p class="text-xs font-semibold text-slate-500 dark:text-slate-400 uppercase tracking-wide">Kategori</p>
                        <div class="flex flex-wrap gap-2">
                            <a href="{{ route('products.index') }}" 
                                class="inline-flex items-center gap-2 rounded-full px-4 py-2 text-sm font-medium transition-all duration-200 
                                    {{ !$selectedCategory 
                                        ? 'bg-gradient-to-r from-[#C26A3D] to-[#F5703B] text-white shadow-md' 
                                        : 'bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-300 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 hover:text-[#C26A3D] dark:hover:text-amber-400' }}">
                                <span>🏷️</span>
                                Semua
                            </a>
                            @foreach ($categories as $category)
                                <a href="{{ route('products.index', array_merge(request()->except('page'), ['category' => $category->slug])) }}" 
                                    class="inline-flex items-center gap-1.5 rounded-full px-4 py-2 text-sm font-medium transition-all duration-200 
                                        {{ $selectedCategory === $category->slug 
                                            ? 'bg-gradient-to-r from-[#C26A3D] to-[#F5703B] text-white shadow-md' 
                                            : 'bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-300 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 hover:text-[#C26A3D] dark:hover:text-amber-400' }}">
                                    {{ $category->name }}
                                    <span class="text-xs opacity-70">({{ $category->products_count ?? 0 }})</span>
                                </a>
                            @endforeach
                        </div>
                    </div>
                </form>
            </div>

            {{-- Products Grid --}}
            <div class="grid gap-5 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                @forelse ($products as $product)
                    <div class="group relative flex flex-col rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 overflow-hidden shadow-sm hover:shadow-xl hover:border-[#C26A3D] dark:hover:border-amber-500 transition-all duration-300 transform hover:-translate-y-1">
                        {{-- Discount Badge --}}
                        @if($product->discount_percent > 0)
                            <div class="absolute top-3 left-3 z-10">
                                <span class="inline-flex items-center gap-1 rounded-full bg-gradient-to-r from-rose-500 to-pink-500 px-2.5 py-1 text-[11px] font-bold text-white shadow-lg">
                                    🔥 -{{ rtrim(rtrim(number_format($product->discount_percent, 1, ',', '.'), '0'), ',') }}%
                                </span>
                            </div>
                        @endif
                        
                        {{-- Product Image --}}
                        <div class="relative h-48 overflow-hidden bg-gradient-to-br from-[#FFF0E6] to-[#FFDDF5] dark:from-slate-800 dark:to-slate-700">
                            <img src="{{ $product->thumbnail }}" alt="{{ $product->name }}" 
                                class="absolute inset-0 h-full w-full object-cover transition-transform duration-500 group-hover:scale-110">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        </div>
                        
                        {{-- Product Info --}}
                        <div class="flex-1 p-4 space-y-3">
                            {{-- Category Badge --}}
                            <span class="inline-flex items-center rounded-lg bg-[#FFE2CF]/70 dark:bg-amber-900/30 px-2.5 py-1 text-[11px] font-semibold uppercase tracking-wider text-[#C26A3D] dark:text-amber-400">
                                {{ $product->category->name }}
                            </span>
                            
                            {{-- Title --}}
                            <a href="{{ route('products.show', $product) }}" class="block">
                                <h3 class="text-sm font-bold text-slate-900 dark:text-white leading-snug line-clamp-2 group-hover:text-[#C26A3D] dark:group-hover:text-amber-400 transition-colors">
                                    {{ $product->name }}
                                </h3>
                            </a>
                            
                            {{-- Description --}}
                            <p class="text-xs text-slate-500 dark:text-slate-400 line-clamp-2">{{ $product->summary }}</p>
                            
                            {{-- Price Section --}}
                            <div class="space-y-1">
                                <div class="flex items-baseline gap-2">
                                    <span class="text-lg font-bold text-[#C26A3D] dark:text-amber-400">
                                        Rp{{ number_format($product->final_price, 0, ',', '.') }}
                                    </span>
                                    @if($product->discount_percent > 0)
                                        <span class="text-xs text-slate-400 dark:text-slate-500 line-through">
                                            Rp{{ number_format($product->price, 0, ',', '.') }}
                                        </span>
                                    @endif
                                </div>
                                @if($product->discount_percent > 0)
                                    <p class="text-[11px] font-medium text-emerald-600 dark:text-emerald-400">
                                        ✨ Hemat Rp{{ number_format($product->price - $product->final_price, 0, ',', '.') }}
                                    </p>
                                @endif
                            </div>
                        </div>
                        
                        {{-- Action Button --}}
                        <div class="p-4 pt-0">
                            <a href="{{ route('products.show', $product) }}" 
                                class="flex items-center justify-center gap-2 rounded-xl border-2 border-[#C26A3D] dark:border-amber-500 px-4 py-2.5 text-sm font-semibold text-[#C26A3D] dark:text-amber-400 hover:bg-gradient-to-r hover:from-[#C26A3D] hover:to-[#F5703B] hover:text-white hover:border-transparent transition-all duration-300">
                                <span>Lihat Detail</span>
                                <svg class="h-4 w-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="sm:col-span-2 lg:col-span-3 xl:col-span-4">
                        <div class="rounded-3xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-12 text-center">
                            <div class="mx-auto flex h-20 w-20 items-center justify-center rounded-2xl bg-slate-100 dark:bg-slate-800 text-5xl mb-4">🔍</div>
                            <h3 class="text-lg font-bold text-slate-900 dark:text-white">Produk Tidak Ditemukan</h3>
                            <p class="text-sm text-slate-500 dark:text-slate-400 mt-2 max-w-md mx-auto">
                                Maaf, tidak ada produk yang cocok dengan pencarian Anda. Coba kata kunci lain atau pilih kategori berbeda.
                            </p>
                            <a href="{{ route('products.index') }}" class="mt-6 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 py-2.5 text-sm font-semibold text-white hover:shadow-md transition">
                                Lihat Semua Produk
                            </a>
                        </div>
                    </div>
                @endforelse
            </div>

            {{-- Pagination --}}
            @if($products->hasPages())
                <div class="flex justify-center">
                    <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 px-4 py-3">
                        {{ $products->onEachSide(1)->links() }}
                    </div>
                </div>
            @endif
        </div>
    </section>
</x-app-layout>

