<x-app-layout>
    <section class="py-10">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-1">
                <p class="text-xs text-slate-500 dark:text-slate-400">Invoice</p>
                <h1 class="text-2xl font-semibold text-slate-900 dark:text-white">{{ $order->invoice_number }}</h1>
                <p class="text-xs text-slate-500 dark:text-slate-400">Dibuat pada {{ $order->created_at->format('d M Y, H:i') }}</p>
            </header>

            {{-- Flash Messages --}}
            @if(session('success'))
                <div class="rounded-xl bg-emerald-50 dark:bg-emerald-900/30 border border-emerald-200 dark:border-emerald-800 p-4">
                    <div class="flex items-center gap-3">
                        <span class="text-emerald-600 dark:text-emerald-400">✓</span>
                        <p class="text-sm font-medium text-emerald-700 dark:text-emerald-300">{{ session('success') }}</p>
                    </div>
                </div>
            @endif
            @if(session('error'))
                <div class="rounded-xl bg-rose-50 dark:bg-rose-900/30 border border-rose-200 dark:border-rose-800 p-4">
                    <div class="flex items-center gap-3">
                        <span class="text-rose-600 dark:text-rose-400">✕</span>
                        <p class="text-sm font-medium text-rose-700 dark:text-rose-300">{{ session('error') }}</p>
                    </div>
                </div>
            @endif

            <div class="grid gap-6 lg:grid-cols-[1.2fr,0.8fr]">
                <div class="space-y-4">
                    <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm space-y-4">
                        <h2 class="text-lg font-semibold text-slate-900 dark:text-white">Detail Produk</h2>
                        <div class="space-y-3 text-sm text-slate-600 dark:text-slate-400">
                            @foreach ($order->items as $item)
                                <div class="flex items-start justify-between gap-4">
                                    <div>
                                        <p class="font-semibold text-slate-900 dark:text-white">{{ $item->product_name }}</p>
                                        <span class="text-xs">{{ $item->quantity }} x Rp{{ number_format($item->unit_price, 0, ',', '.') }}</span>
                                    </div>
                                    <p class="font-semibold text-[#C26A3D] dark:text-amber-400">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm space-y-3 text-sm text-slate-600 dark:text-slate-400">
                        <h2 class="text-lg font-semibold text-slate-900 dark:text-white">Pengiriman</h2>
                        <p><strong class="text-slate-900 dark:text-white">Kurir:</strong> {{ strtoupper($order->shipping_courier ?? 'Pickup') }}</p>
                        <p><strong class="text-slate-900 dark:text-white">Alamat:</strong> {{ $order->shipping_address['address_line1'] ?? '-' }}, {{ $order->shipping_address['city'] ?? '' }}, {{ $order->shipping_address['province'] ?? '' }}</p>
                        <p><strong class="text-slate-900 dark:text-white">Catatan:</strong> {{ $order->notes ?? '-' }}</p>
                    </div>
                </div>

                <aside class="space-y-4">
                    <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-white dark:bg-slate-900 p-6 shadow-sm space-y-3 text-sm text-slate-600 dark:text-slate-400">
                        <h2 class="text-lg font-semibold text-slate-900 dark:text-white">Ringkasan Biaya</h2>
                        <div class="flex justify-between">
                            <span>Subtotal</span>
                            <span>Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Diskon</span>
                            <span>- Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Ongkos Kirim</span>
                            <span>Rp{{ number_format($order->shipping_cost, 0, ',', '.') }}</span>
                        </div>
                        <hr class="border-[#FAD4C2] dark:border-slate-700">
                        <div class="flex justify-between text-base font-semibold text-slate-900 dark:text-white">
                            <span>Total Bayar</span>
                            <span>Rp{{ number_format($order->grand_total, 0, ',', '.') }}</span>
                        </div>
                        <p class="text-xs text-slate-500 dark:text-slate-400">Status pembayaran: {{ strtoupper($order->payment_status) }}</p>
                    </div>

                    <div class="rounded-3xl border border-[#FAD4C2] dark:border-slate-800 bg-[#FFF8F3] dark:bg-slate-800 p-6 shadow-sm space-y-3 text-sm text-slate-600 dark:text-slate-400">
                        <p class="font-semibold text-slate-900 dark:text-white">Butuh bukti pembayaran?</p>
                        @if ($order->payments->isNotEmpty())
                            <ul class="list-disc space-y-1 pl-5">
                                @foreach ($order->payments as $payment)
                                    <li>{{ strtoupper($payment->method) }} – {{ $payment->status }} – {{ $payment->reference }}</li>
                                @endforeach
                            </ul>
                        @else
                            <p>Belum ada riwayat pembayaran tercatat.</p>
                        @endif
                        <a href="{{ route('orders.print', $order) }}" target="_blank" class="inline-flex items-center rounded-full border border-[#C26A3D] dark:border-amber-500 px-4 py-2 text-xs font-semibold text-[#C26A3D] dark:text-amber-400 hover:bg-[#FFE2CF] dark:hover:bg-amber-900/30 transition">Cetak Struk</a>
                    </div>

                    {{-- Cancel Order Section --}}
                    @php
                        $canCancel = in_array($order->status, ['pending', 'awaiting_payment']) && $order->payment_status !== 'paid';
                    @endphp
                    @if($canCancel)
                        <div class="rounded-3xl border border-rose-200 dark:border-rose-900/50 bg-rose-50 dark:bg-rose-900/20 p-6 shadow-sm space-y-3">
                            <div class="flex items-center gap-2">
                                <span class="text-rose-600 dark:text-rose-400">⚠️</span>
                                <p class="font-semibold text-rose-700 dark:text-rose-300 text-sm">Batalkan Pesanan</p>
                            </div>
                            <p class="text-xs text-rose-600 dark:text-rose-400">Pesanan yang dibatalkan tidak dapat dikembalikan. Stok produk akan dikembalikan secara otomatis.</p>
                            <button type="button" onclick="showCancelModal()" class="inline-flex items-center gap-2 rounded-xl bg-rose-600 hover:bg-rose-700 px-4 py-2.5 text-xs font-semibold text-white transition shadow-sm">
                                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                                Batalkan Pesanan Ini
                            </button>
                        </div>
                    @elseif($order->status === 'cancelled')
                        <div class="rounded-3xl border border-slate-200 dark:border-slate-700 bg-slate-50 dark:bg-slate-800 p-6 shadow-sm">
                            <div class="flex items-center gap-2">
                                <span class="text-slate-500">❌</span>
                                <p class="font-semibold text-slate-600 dark:text-slate-400 text-sm">Pesanan Dibatalkan</p>
                            </div>
                            @if(isset($order->metadata['cancellation_reason']))
                                <p class="text-xs text-slate-500 dark:text-slate-400 mt-2">Alasan: {{ $order->metadata['cancellation_reason'] }}</p>
                            @endif
                        </div>
                    @endif
                </aside>
            </div>
        </div>
    </section>

    {{-- Cancel Confirmation Modal --}}
    <div id="cancelModal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black/50 backdrop-blur-sm p-4">
        <div class="w-full max-w-md rounded-3xl bg-white dark:bg-slate-900 shadow-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-rose-500 to-rose-600 px-6 py-4">
                <h3 class="text-lg font-bold text-white">Konfirmasi Batalkan Pesanan</h3>
            </div>
            <form action="{{ route('orders.cancel', $order) }}" method="POST" class="p-6 space-y-4">
                @csrf
                <div class="flex items-start gap-3 p-4 rounded-xl bg-rose-50 dark:bg-rose-900/20 border border-rose-200 dark:border-rose-800">
                    <span class="text-2xl">⚠️</span>
                    <div>
                        <p class="text-sm font-semibold text-rose-700 dark:text-rose-300">Apakah Anda yakin?</p>
                        <p class="text-xs text-rose-600 dark:text-rose-400 mt-1">Pesanan <strong>{{ $order->invoice_number }}</strong> akan dibatalkan dan tidak dapat dikembalikan.</p>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">Alasan Pembatalan (opsional)</label>
                    <textarea name="reason" rows="3" placeholder="Contoh: Ingin ganti produk, tidak jadi beli, dll." class="w-full rounded-xl border-2 border-slate-200 dark:border-slate-700 bg-white dark:bg-slate-800 px-4 py-3 text-sm text-slate-900 dark:text-white placeholder-slate-400 focus:border-rose-500 dark:focus:border-rose-400 focus:ring-2 focus:ring-rose-200 dark:focus:ring-rose-900/50 transition"></textarea>
                </div>
                <div class="flex items-center justify-end gap-3 pt-2">
                    <button type="button" onclick="hideCancelModal()" class="rounded-xl border-2 border-slate-300 dark:border-slate-600 px-5 py-2.5 text-sm font-semibold text-slate-600 dark:text-slate-400 hover:bg-slate-100 dark:hover:bg-slate-800 transition">Batal</button>
                    <button type="submit" class="rounded-xl bg-rose-600 hover:bg-rose-700 px-5 py-2.5 text-sm font-semibold text-white shadow-md transition">Ya, Batalkan Pesanan</button>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
    <script>
        function showCancelModal() {
            document.getElementById('cancelModal').classList.remove('hidden');
            document.getElementById('cancelModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
        }
        function hideCancelModal() {
            document.getElementById('cancelModal').classList.add('hidden');
            document.getElementById('cancelModal').classList.remove('flex');
            document.body.style.overflow = '';
        }
        // Close modal on backdrop click
        document.getElementById('cancelModal')?.addEventListener('click', function(e) {
            if (e.target === this) hideCancelModal();
        });
        // Close modal on Escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') hideCancelModal();
        });
    </script>
    @endpush
</x-app-layout>
