﻿<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Struk {{ $order->invoice_number }}</title>
    <style>
        body { font-family: "Poppins", Arial, sans-serif; margin: 0; padding: 24px; background: #fdf7f3; color: #1f2937; }
        .receipt { max-width: 720px; margin: 0 auto; background: #fff; border: 1px solid #f4c7ad; border-radius: 24px; padding: 32px; }
        h1 { font-size: 20px; margin-bottom: 8px; }
        .meta { font-size: 12px; color: #6b7280; }
        table { width: 100%; border-collapse: collapse; margin-top: 16px; }
        th, td { padding: 8px 0; font-size: 13px; }
        tfoot td { font-weight: 600; }
        .totals td { border-top: 1px solid #f4c7ad; }
        .badge { display: inline-flex; align-items: center; padding: 4px 10px; border-radius: 999px; font-size: 11px; font-weight: 600; text-transform: uppercase; }
        .status { background: #ffe2cf; color: #c26a3d; }
        .payment { background: #fff3e6; color: #6b7280; }
        .footer { margin-top: 24px; font-size: 11px; color: #6b7280; text-align: center; }
        @media print { body { padding: 0; background: #fff; } .receipt { border-radius: 0; border: none; } }
    </style>
</head>
<body>
    <div class="receipt">
        <header class="flex items-center justify-between gap-4">
            <h1>{{ $storeName }}</h1>
            <p class="meta">Invoice {{ $order->invoice_number }} · {{ $order->created_at->format('d M Y, H:i') }}</p>
            <div style="margin-top:12px; display:flex; gap:8px;">
                <span class="badge status">{{ strtoupper($order->status) }}</span>
                <span class="badge payment">{{ strtoupper($order->payment_status) }}</span>
            </div>
            <button onclick="window.print()" style="margin-left:auto; padding:8px 12px; border-radius:8px; border:none; background:#C26A3D; color:#fff; cursor:pointer;" aria-label="Cetak Struk">
                Cetak
            </button>
        </header>

        <section style="margin-top:24px;">
            <h2 style="font-size:15px; margin-bottom:8px;">Ringkasan Produk</h2>
            <table>
                <thead>
                    <tr style="border-bottom:1px solid #f4c7ad;">
                        <th style="text-align:left;">Produk</th>
                        <th style="text-align:right;">Jumlah</th>
                        <th style="text-align:right;">Subtotal</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($order->items as $item)
                        <tr>
                            <td>{{ $item->product_name }}</td>
                            <td style="text-align:right;">{{ $item->quantity }} x Rp{{ number_format($item->unit_price, 0, ',', '.') }}</td>
                            <td style="text-align:right;">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot class="totals">
                    <tr>
                        <td>Subtotal</td>
                        <td></td>
                        <td style="text-align:right;">Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Diskon</td>
                        <td></td>
                        <td style="text-align:right;">- Rp{{ number_format($order->discount_amount, 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Ongkos Kirim</td>
                        <td></td>
                        <td style="text-align:right;">Rp{{ number_format($order->shipping_cost, 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Total Bayar</td>
                        <td></td>
                        <td style="text-align:right;">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</td>
                    </tr>
                </tfoot>
            </table>
        </section>

        <section style="margin-top:24px; font-size:13px;">
            <h2 style="font-size:15px; margin-bottom:8px;">Pengiriman</h2>
            <p><strong>Kurir:</strong> {{ strtoupper($order->shipping_courier ?? 'Pickup') }}</p>
            <p><strong>Alamat:</strong> {{ $order->shipping_address['address_line1'] ?? '-' }}, {{ $order->shipping_address['city'] ?? '-' }}, {{ $order->shipping_address['province'] ?? '-' }}</p>
            <p><strong>Catatan:</strong> {{ $order->notes ?? '-' }}</p>
        </section>

        <section style="margin-top:24px; font-size:13px;">
            <h2 style="font-size:15px; margin-bottom:8px;">Pembayaran</h2>
            @if ($order->payments->isNotEmpty())
                <ul style="margin:0; padding-left:18px;">
                    @foreach ($order->payments as $payment)
                        <li>{{ strtoupper($payment->method) }} · {{ strtoupper($payment->status) }} · {{ $payment->reference }}</li>
                    @endforeach
                </ul>
            @else
                <p>Belum ada riwayat pembayaran.</p>
            @endif
        </section>

        <p class="footer">Terima kasih telah berbelanja di {{ $storeName }}. Hubungi admin di WhatsApp +{{ \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012') }} jika membutuhkan bantuan.</p>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const printButton = document.querySelector('button[aria-label="Cetak Struk"]');
            if (printButton) {
                printButton.addEventListener('click', () => window.print());
            }
        });
    </script>
</body>
</html>


