<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-slate-800 leading-tight">
            Pembayaran - {{ $order->invoice_number }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            @if (session('status'))
                <div class="mb-6 rounded-xl bg-green-50 border border-green-200 p-4">
                    <div class="flex items-center gap-3">
                        <svg class="h-5 w-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <p class="text-sm font-medium text-green-800">{{ session('status') }}</p>
                    </div>
                </div>
            @endif

            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <div class="p-6 border-b border-slate-200">
                    <h3 class="text-lg font-semibold text-slate-900">Detail Pesanan</h3>
                    <p class="text-sm text-slate-600 mt-1">Invoice: {{ $order->invoice_number }}</p>
                </div>

                <div class="p-6">
                    <div class="grid md:grid-cols-2 gap-6 mb-6">
                        <div>
                            <h4 class="text-sm font-semibold text-slate-900 mb-3">Informasi Pesanan</h4>
                            <dl class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <dt class="text-slate-600">Total Pembayaran</dt>
                                    <dd class="font-semibold text-slate-900">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</dd>
                                </div>
                                <div class="flex justify-between">
                                    <dt class="text-slate-600">Metode Pembayaran</dt>
                                    <dd class="text-slate-900">{{ strtoupper($order->payment_method) }}</dd>
                                </div>
                                <div class="flex justify-between">
                                    <dt class="text-slate-600">Status</dt>
                                    <dd>
                                        <span class="inline-flex rounded-full px-2.5 py-1 text-xs font-semibold
                                            @if($order->payment_status === 'paid') bg-green-100 text-green-700
                                            @elseif($order->payment_status === 'waiting_confirmation') bg-yellow-100 text-yellow-700
                                            @else bg-red-100 text-red-700
                                            @endif">
                                            {{ strtoupper($order->payment_status) }}
                                        </span>
                                    </dd>
                                </div>
                            </dl>
                        </div>
                        <div>
                            <h4 class="text-sm font-semibold text-slate-900 mb-3">Alamat Pengiriman</h4>
                            <div class="text-sm text-slate-600 space-y-1">
                                <p class="font-medium text-slate-900">{{ data_get($order->shipping_address, 'recipient_name') }}</p>
                                <p>{{ data_get($order->shipping_address, 'address_line1') }}</p>
                                @if(data_get($order->shipping_address, 'address_line2'))
                                    <p>{{ data_get($order->shipping_address, 'address_line2') }}</p>
                                @endif
                                <p>{{ data_get($order->shipping_address, 'city') }}, {{ data_get($order->shipping_address, 'province') }}</p>
                                <p>{{ data_get($order->shipping_address, 'postal_code') }}</p>
                                <p class="mt-2">Telp: {{ data_get($order->shipping_address, 'phone') }}</p>
                            </div>
                        </div>
                    </div>

                    @if($payment->status !== 'paid')
                        <div id="snap-container" class="mb-6">
                            <div class="rounded-xl bg-slate-50 border-2 border-dashed border-slate-200 p-8 text-center">
                                <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-[#C26A3D] mx-auto mb-4"></div>
                                <p class="text-sm text-slate-600">Memuat halaman pembayaran...</p>
                            </div>
                        </div>
                    @else
                        <div class="rounded-xl bg-green-50 border border-green-200 p-6 text-center">
                            <svg class="h-12 w-12 text-green-600 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <h4 class="text-lg font-semibold text-green-900 mb-2">Pembayaran Berhasil</h4>
                            <p class="text-sm text-green-700 mb-4">Pesanan Anda akan segera diproses.</p>
                            <a href="{{ route('orders.show', $order) }}" class="inline-flex items-center rounded-xl bg-[#C26A3D] px-6 py-2.5 text-sm font-semibold text-white hover:bg-[#a85327] transition">
                                Lihat Detail Pesanan
                            </a>
                        </div>
                    @endif

                    <div class="flex flex-wrap gap-3 pt-6 border-t border-slate-200">
                        <a href="{{ route('orders.show', $order) }}" class="inline-flex items-center rounded-xl border border-slate-300 px-4 py-2 text-sm font-semibold text-slate-700 hover:bg-slate-50 transition">
                            Kembali ke Detail Pesanan
                        </a>
                        <a href="{{ route('orders.index') }}" class="inline-flex items-center rounded-xl border border-slate-300 px-4 py-2 text-sm font-semibold text-slate-700 hover:bg-slate-50 transition">
                            Lihat Semua Pesanan
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if($payment->status !== 'paid' && $payment->snap_token)
        <!-- Midtrans Snap.js -->
        @if($isProduction)
            <script src="https://app.midtrans.com/snap/snap.js" data-client-key="{{ $midtransClientKey }}"></script>
        @else
            <script src="https://app.sandbox.midtrans.com/snap/snap.js" data-client-key="{{ $midtransClientKey }}"></script>
        @endif
        <script>
            // Check if snap.js is loaded
            if (typeof window.snap === 'undefined') {
                console.error('Midtrans Snap.js failed to load');
                document.getElementById('snap-container').innerHTML = `
                    <div class="rounded-xl bg-red-50 border border-red-200 p-6 text-center">
                        <svg class="h-12 w-12 text-red-600 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <h4 class="text-lg font-semibold text-red-900 mb-2">Gagal Memuat Pembayaran</h4>
                        <p class="text-sm text-red-700 mb-4">Silakan refresh halaman atau hubungi administrator.</p>
                        <button onclick="window.location.reload()" class="inline-flex items-center rounded-xl bg-red-600 px-4 py-2 text-sm font-semibold text-white hover:bg-red-700 transition">
                            Refresh Halaman
                        </button>
                    </div>
                `;
            } else {
                // Validate token before calling snap.pay
                const snapToken = '{{ $payment->snap_token }}';
                
                // Midtrans tokens are UUIDs, so we can't check by format
                // Instead, we'll just try to use the token directly
                // If it fails, Midtrans will show an error
                
                // Real token, proceed with payment
                window.snap.pay(snapToken, {
                    onSuccess: function(result){
                        console.log('Payment success:', result);
                        window.location.href = '{{ route('orders.show', $order) }}?payment=success';
                    },
                    onPending: function(result){
                        console.log('Payment pending:', result);
                        window.location.href = '{{ route('orders.show', $order) }}?payment=pending';
                    },
                    onError: function(result){
                        console.log('Payment error:', result);
                        document.getElementById('snap-container').innerHTML = `
                            <div class="rounded-xl bg-red-50 border border-red-200 p-6 text-center">
                                <svg class="h-12 w-12 text-red-600 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <h4 class="text-lg font-semibold text-red-900 mb-2">Gagal Memproses Pembayaran</h4>
                                <p class="text-sm text-red-700 mb-4">${result.status_message || 'Terjadi kesalahan saat memproses pembayaran.'}</p>
                                <p class="text-xs text-red-600 mb-4">Token: ${snapToken.substring(0, 20)}...</p>
                                <a href="{{ route('orders.show', $order) }}" class="inline-flex items-center rounded-xl bg-red-600 px-4 py-2 text-sm font-semibold text-white hover:bg-red-700 transition">
                                    Kembali ke Detail Pesanan
                                </a>
                            </div>
                        `;
                    },
                    onClose: function(){
                        console.log('Payment dialog closed');
                        // User closed the payment dialog, stay on page
                    }
                });
            }
        </script>
    @endif
</x-app-layout>

