@php
    $statusColors = [
        'pending' => ['bg' => 'bg-amber-100 dark:bg-amber-900/30', 'text' => 'text-amber-700 dark:text-amber-300', 'icon' => '⏳'],
        'awaiting_payment' => ['bg' => 'bg-amber-100 dark:bg-amber-900/30', 'text' => 'text-amber-700 dark:text-amber-300', 'icon' => '💳'],
        'confirmed' => ['bg' => 'bg-blue-100 dark:bg-blue-900/30', 'text' => 'text-blue-700 dark:text-blue-300', 'icon' => '✅'],
        'processing' => ['bg' => 'bg-sky-100 dark:bg-sky-900/30', 'text' => 'text-sky-700 dark:text-sky-300', 'icon' => '📦'],
        'ready_to_ship' => ['bg' => 'bg-indigo-100 dark:bg-indigo-900/30', 'text' => 'text-indigo-700 dark:text-indigo-300', 'icon' => '🚀'],
        'shipping' => ['bg' => 'bg-blue-100 dark:bg-blue-900/30', 'text' => 'text-blue-700 dark:text-blue-300', 'icon' => '🚚'],
        'completed' => ['bg' => 'bg-emerald-100 dark:bg-emerald-900/30', 'text' => 'text-emerald-700 dark:text-emerald-300', 'icon' => '✨'],
        'cancelled' => ['bg' => 'bg-rose-100 dark:bg-rose-900/30', 'text' => 'text-rose-700 dark:text-rose-300', 'icon' => '❌'],
    ];
    $statusLabels = [
        'pending' => 'Menunggu',
        'awaiting_payment' => 'Menunggu Bayar',
        'confirmed' => 'Dikonfirmasi',
        'processing' => 'Diproses',
        'ready_to_ship' => 'Siap Kirim',
        'shipping' => 'Dikirim',
        'completed' => 'Selesai',
        'cancelled' => 'Dibatalkan',
    ];
    $paymentLabels = [
        'pending' => 'Belum Bayar',
        'paid' => 'Lunas',
        'failed' => 'Gagal',
        'refunded' => 'Refund',
    ];
    $paymentColors = [
        'pending' => ['bg' => 'bg-amber-100 dark:bg-amber-900/30', 'text' => 'text-amber-700 dark:text-amber-300'],
        'paid' => ['bg' => 'bg-emerald-100 dark:bg-emerald-900/30', 'text' => 'text-emerald-700 dark:text-emerald-300'],
        'failed' => ['bg' => 'bg-rose-100 dark:bg-rose-900/30', 'text' => 'text-rose-700 dark:text-rose-300'],
        'refunded' => ['bg' => 'bg-slate-100 dark:bg-slate-800', 'text' => 'text-slate-700 dark:text-slate-300'],
    ];
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <div>
                <p class="text-xs font-semibold uppercase tracking-wide text-[#C26A3D]/80 dark:text-amber-400/80">Pesanan Anda</p>
                <h1 class="text-2xl font-bold text-slate-900 dark:text-white">Riwayat Pesanan 📋</h1>
                <p class="text-sm text-slate-500 dark:text-slate-400 mt-1">Pantau status pesanan dan pembayaran Anda.</p>
            </div>
            <div class="flex items-center gap-3">
                <a href="{{ route('products.index') }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-4 py-2.5 text-sm font-semibold text-white shadow-md hover:shadow-lg transition">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/></svg>
                    Belanja Lagi
                </a>
            </div>
        </div>
    </x-slot>

    <section class="py-8">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            
            {{-- Stats Summary Cards --}}
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-blue-100 dark:bg-blue-900/30 text-xl">📦</div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Total Pesanan</p>
                            <p class="text-xl font-bold text-slate-900 dark:text-white">{{ $orders->total() }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-100 dark:bg-amber-900/30 text-xl">⏳</div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Menunggu Bayar</p>
                            <p class="text-xl font-bold text-amber-600 dark:text-amber-400">{{ $orders->where('payment_status', '!=', 'paid')->count() }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-sky-100 dark:bg-sky-900/30 text-xl">🚚</div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Sedang Proses</p>
                            <p class="text-xl font-bold text-sky-600 dark:text-sky-400">{{ $orders->whereIn('status', ['processing', 'ready_to_ship', 'shipping'])->count() }}</p>
                        </div>
                    </div>
                </div>
                <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-100 dark:bg-emerald-900/30 text-xl">✅</div>
                        <div>
                            <p class="text-xs font-medium text-slate-500 dark:text-slate-400">Selesai</p>
                            <p class="text-xl font-bold text-emerald-600 dark:text-emerald-400">{{ $orders->where('status', 'completed')->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Search & Filter Section --}}
            <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-4 shadow-sm">
                <form method="GET" action="{{ route('orders.index') }}" class="flex flex-col sm:flex-row gap-3">
                    <div class="relative flex-1">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <svg class="h-5 w-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                        <input type="text" name="search" value="{{ request('search') }}" 
                            placeholder="Cari invoice atau produk..." 
                            class="w-full pl-11 pr-4 py-3 rounded-xl border-2 border-[#FAD4C2]/60 dark:border-slate-700 bg-[#FFF8F3] dark:bg-slate-800 text-slate-900 dark:text-white placeholder-slate-400 text-sm focus:border-[#C26A3D] dark:focus:border-amber-500 focus:ring-2 focus:ring-orange-200 dark:focus:ring-amber-900/50 transition" />
                    </div>
                    <select name="status" class="rounded-xl border-2 border-[#FAD4C2]/60 dark:border-slate-700 bg-[#FFF8F3] dark:bg-slate-800 text-slate-900 dark:text-white px-4 py-3 text-sm focus:border-[#C26A3D] dark:focus:border-amber-500 focus:ring-2 focus:ring-orange-200 dark:focus:ring-amber-900/50 transition">
                        <option value="">Semua Status</option>
                        @foreach($statusLabels as $key => $label)
                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                    <button type="submit" class="inline-flex items-center justify-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 py-3 text-sm font-semibold text-white shadow-md hover:shadow-lg transition transform hover:scale-[1.02]">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        Cari
                    </button>
                </form>
            </div>

            {{-- Orders List --}}
            <div class="space-y-4">
                @forelse ($orders as $order)
                    @php
                        $status = $statusColors[$order->status] ?? ['bg' => 'bg-slate-100', 'text' => 'text-slate-600', 'icon' => '📋'];
                        $payment = $paymentColors[$order->payment_status] ?? ['bg' => 'bg-slate-100', 'text' => 'text-slate-600'];
                    @endphp
                    <article class="group rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 overflow-hidden shadow-sm hover:shadow-lg hover:border-[#C26A3D] dark:hover:border-amber-500 transition-all duration-300">
                        {{-- Order Header --}}
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 p-5 border-b border-[#FAD4C2]/40 dark:border-slate-800 bg-gradient-to-r from-[#FFF8F3] to-[#FFEEE5] dark:from-slate-800/50 dark:to-slate-800">
                            <div class="flex items-center gap-4">
                                <div class="flex h-12 w-12 items-center justify-center rounded-xl {{ $status['bg'] }} text-2xl">
                                    {{ $status['icon'] }}
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-900 dark:text-white">{{ $order->invoice_number }}</p>
                                    <p class="text-xs text-slate-500 dark:text-slate-400 flex items-center gap-1.5">
                                        <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                        {{ $order->created_at->translatedFormat('d F Y, H:i') }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex flex-wrap gap-2">
                                <span class="inline-flex items-center gap-1.5 rounded-full {{ $status['bg'] }} {{ $status['text'] }} px-3 py-1.5 text-xs font-semibold">
                                    {{ $statusLabels[$order->status] ?? ucfirst($order->status) }}
                                </span>
                                <span class="inline-flex items-center gap-1.5 rounded-full {{ $payment['bg'] }} {{ $payment['text'] }} px-3 py-1.5 text-xs font-semibold">
                                    {{ $paymentLabels[$order->payment_status] ?? ucfirst($order->payment_status) }}
                                </span>
                            </div>
                        </div>

                        {{-- Order Details --}}
                        <div class="p-5">
                            <div class="grid gap-4 sm:grid-cols-4 text-sm">
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-slate-100 dark:bg-slate-800 text-lg">🛒</div>
                                    <div>
                                        <p class="text-xs text-slate-500 dark:text-slate-400">Produk</p>
                                        <p class="font-semibold text-slate-900 dark:text-white">{{ $order->total_items }} item</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-slate-100 dark:bg-slate-800 text-lg">💳</div>
                                    <div>
                                        <p class="text-xs text-slate-500 dark:text-slate-400">Metode</p>
                                        <p class="font-semibold text-slate-900 dark:text-white">{{ strtoupper($order->payment_method) }}</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-slate-100 dark:bg-slate-800 text-lg">🚚</div>
                                    <div>
                                        <p class="text-xs text-slate-500 dark:text-slate-400">Ekspedisi</p>
                                        <p class="font-semibold text-slate-900 dark:text-white">{{ strtoupper($order->shipping_courier ?? 'Pickup') }}</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-3">
                                    <div class="flex h-9 w-9 items-center justify-center rounded-lg bg-gradient-to-br from-[#FFE2CF] to-[#FFDDF5] dark:from-amber-900/30 dark:to-pink-900/30 text-lg">💰</div>
                                    <div>
                                        <p class="text-xs text-slate-500 dark:text-slate-400">Total</p>
                                        <p class="font-bold text-[#C26A3D] dark:text-amber-400">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</p>
                                    </div>
                                </div>
                            </div>

                            {{-- Action Buttons --}}
                            <div class="mt-5 flex flex-wrap items-center justify-between gap-3 pt-4 border-t border-[#FAD4C2]/40 dark:border-slate-800">
                                <span class="text-xs text-slate-500 dark:text-slate-400">
                                    Diperbarui {{ $order->updated_at->diffForHumans() }}
                                </span>
                                <div class="flex flex-wrap gap-2">
                                    @php
                                        $detailRoute = 'orders.show';
                                        if (Auth::guard('admin')->check()) {
                                            $detailRoute = 'admin.orders.detail';
                                        } elseif (Auth::guard('cashier')->check()) {
                                            $detailRoute = 'cashier.orders.detail';
                                        }
                                        $canCancel = in_array($order->status, ['pending', 'awaiting_payment']) && $order->payment_status !== 'paid';
                                    @endphp
                                    @if($order->payment_status !== 'paid' && $order->status !== 'cancelled')
                                        <a href="{{ route('orders.payment', $order) }}" class="inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-emerald-500 to-emerald-600 px-4 py-2 text-xs font-semibold text-white hover:shadow-md transition">
                                            <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                            Bayar Sekarang
                                        </a>
                                    @endif
                                    @if($canCancel)
                                        <button type="button" onclick="showCancelModal{{ $order->id }}()" class="inline-flex items-center gap-2 rounded-xl border-2 border-rose-500 dark:border-rose-400 px-4 py-2 text-xs font-semibold text-rose-600 dark:text-rose-400 hover:bg-rose-600 hover:text-white hover:border-rose-600 transition-all duration-300">
                                            <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                                            Batalkan
                                        </button>
                                    @endif
                                    <a href="{{ route($detailRoute, $order) }}" class="inline-flex items-center gap-2 rounded-xl border-2 border-[#C26A3D] dark:border-amber-500 px-4 py-2 text-xs font-semibold text-[#C26A3D] dark:text-amber-400 hover:bg-gradient-to-r hover:from-[#C26A3D] hover:to-[#F5703B] hover:text-white hover:border-transparent transition-all duration-300">
                                        <svg class="h-3.5 w-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                                        Detail Pesanan
                                    </a>
                                </div>
                            </div>
                        </div>
                    </article>
                @empty
                    <div class="rounded-3xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 p-12 text-center">
                        <div class="mx-auto flex h-20 w-20 items-center justify-center rounded-2xl bg-slate-100 dark:bg-slate-800 text-5xl mb-4">📭</div>
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white">Belum Ada Pesanan</h3>
                        <p class="text-sm text-slate-500 dark:text-slate-400 mt-2 max-w-md mx-auto">
                            Anda belum memiliki pesanan. Mulai belanja untuk membuat pesanan pertama Anda!
                        </p>
                        <a href="{{ route('products.index') }}" class="mt-6 inline-flex items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 py-2.5 text-sm font-semibold text-white hover:shadow-md transition">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                            Mulai Belanja
                        </a>
                    </div>
                @endforelse
            </div>

            {{-- Pagination --}}
            @if($orders->hasPages())
                <div class="flex justify-center">
                    <div class="rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800 bg-white dark:bg-slate-900 px-4 py-3">
                        {{ $orders->onEachSide(1)->links() }}
                    </div>
                </div>
            @endif

            {{-- Flash Messages --}}
            @if(session('success'))
                <div class="fixed bottom-4 right-4 z-50 rounded-xl bg-emerald-600 px-6 py-4 text-white shadow-lg animate-pulse" id="flashSuccess">
                    <div class="flex items-center gap-3">
                        <span>✓</span>
                        <p class="font-medium">{{ session('success') }}</p>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-2 hover:opacity-70">×</button>
                    </div>
                </div>
            @endif
            @if(session('error'))
                <div class="fixed bottom-4 right-4 z-50 rounded-xl bg-rose-600 px-6 py-4 text-white shadow-lg" id="flashError">
                    <div class="flex items-center gap-3">
                        <span>✕</span>
                        <p class="font-medium">{{ session('error') }}</p>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-2 hover:opacity-70">×</button>
                    </div>
                </div>
            @endif
        </div>
    </section>

    {{-- Cancel Modals for each order --}}
    @foreach($orders as $order)
        @php
            $canCancelOrder = in_array($order->status, ['pending', 'awaiting_payment']) && $order->payment_status !== 'paid';
        @endphp
        @if($canCancelOrder)
            <div id="cancelModal{{ $order->id }}" class="fixed inset-0 z-50 hidden items-center justify-center bg-black/50 backdrop-blur-sm p-4">
                <div class="w-full max-w-md rounded-3xl bg-white dark:bg-slate-900 shadow-2xl overflow-hidden">
                    <div class="bg-gradient-to-r from-rose-500 to-rose-600 px-6 py-4">
                        <h3 class="text-lg font-bold text-white">Batalkan Pesanan</h3>
                    </div>
                    <form action="{{ route('orders.cancel', $order) }}" method="POST" class="p-6 space-y-4">
                        @csrf
                        <div class="flex items-start gap-3 p-4 rounded-xl bg-rose-50 dark:bg-rose-900/20 border border-rose-200 dark:border-rose-800">
                            <span class="text-2xl">⚠️</span>
                            <div>
                                <p class="text-sm font-semibold text-rose-700 dark:text-rose-300">Apakah Anda yakin?</p>
                                <p class="text-xs text-rose-600 dark:text-rose-400 mt-1">Pesanan <strong>{{ $order->invoice_number }}</strong> akan dibatalkan.</p>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-2">Alasan (opsional)</label>
                            <textarea name="reason" rows="2" placeholder="Contoh: Tidak jadi beli, salah pesan..." class="w-full rounded-xl border-2 border-slate-200 dark:border-slate-700 bg-white dark:bg-slate-800 px-4 py-3 text-sm text-slate-900 dark:text-white placeholder-slate-400 focus:border-rose-500 transition"></textarea>
                        </div>
                        <div class="flex items-center justify-end gap-3 pt-2">
                            <button type="button" onclick="hideCancelModal{{ $order->id }}()" class="rounded-xl border-2 border-slate-300 dark:border-slate-600 px-5 py-2.5 text-sm font-semibold text-slate-600 dark:text-slate-400 hover:bg-slate-100 dark:hover:bg-slate-800 transition">Batal</button>
                            <button type="submit" class="rounded-xl bg-rose-600 hover:bg-rose-700 px-5 py-2.5 text-sm font-semibold text-white shadow-md transition">Ya, Batalkan</button>
                        </div>
                    </form>
                </div>
            </div>
        @endif
    @endforeach

    @push('scripts')
    <script>
        // Auto-hide flash messages after 5 seconds
        setTimeout(function() {
            const flashSuccess = document.getElementById('flashSuccess');
            const flashError = document.getElementById('flashError');
            if (flashSuccess) flashSuccess.remove();
            if (flashError) flashError.remove();
        }, 5000);

        // Modal functions for each order
        @foreach($orders as $order)
            @php $canCancelOrder = in_array($order->status, ['pending', 'awaiting_payment']) && $order->payment_status !== 'paid'; @endphp
            @if($canCancelOrder)
                function showCancelModal{{ $order->id }}() {
                    document.getElementById('cancelModal{{ $order->id }}').classList.remove('hidden');
                    document.getElementById('cancelModal{{ $order->id }}').classList.add('flex');
                    document.body.style.overflow = 'hidden';
                }
                function hideCancelModal{{ $order->id }}() {
                    document.getElementById('cancelModal{{ $order->id }}').classList.add('hidden');
                    document.getElementById('cancelModal{{ $order->id }}').classList.remove('flex');
                    document.body.style.overflow = '';
                }
                document.getElementById('cancelModal{{ $order->id }}')?.addEventListener('click', function(e) {
                    if (e.target === this) hideCancelModal{{ $order->id }}();
                });
            @endif
        @endforeach
        
        // Close all modals on Escape
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                document.querySelectorAll('[id^="cancelModal"]').forEach(modal => {
                    modal.classList.add('hidden');
                    modal.classList.remove('flex');
                });
                document.body.style.overflow = '';
            }
        });
    </script>
    @endpush
</x-app-layout>
