﻿@php
    $brandName = \App\Models\StoreSetting::getValue('store.name', config('app.name', "D'Shop"));
    $brandLogo = \App\Models\StoreSetting::getValue('store.logo', 'assets/logo-dshop.png');
    $brandLogoUrl = (!empty($brandLogo) && !preg_match('/^(https?:)?\/\//', $brandLogo) && ! str_starts_with($brandLogo, 'data:'))
        ? asset($brandLogo)
        : $brandLogo;
    $brandTagline = \App\Models\StoreSetting::getValue('store.tagline', 'Solusi UMKM Profesional.');
    $adminWhatsapp = \App\Models\StoreSetting::getValue('store.whatsapp_admin', '6283879865012');
    $navItems = [
        ['label' => 'Dashboard', 'route' => 'admin.dashboard', 'icon' => 'grid'],
        ['label' => 'Kasir/POS', 'route' => 'cashier.dashboard', 'icon' => 'pos'],
        ['label' => 'Produk', 'route' => 'admin.products.index', 'icon' => 'box'],
        ['label' => 'Kategori', 'route' => 'admin.categories.index', 'icon' => 'category'],
        ['label' => 'Pesanan', 'route' => 'admin.orders.index', 'icon' => 'cart'],
        ['label' => 'Laporan Penjualan', 'route' => 'admin.income.index', 'icon' => 'chart'],
        ['label' => 'Pelanggan', 'route' => 'admin.customers.index', 'icon' => 'customers'],
        ['label' => 'Pengaturan', 'route' => 'admin.settings.index', 'icon' => 'settings'],
    ];
    $currentRoute = request()->route()?->getName();
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', "D'Shop") }} • Admin</title>

        <link rel="icon" type="image/png" href="{{ $brandLogoUrl }}">
        <link rel="shortcut icon" href="{{ $brandLogoUrl }}" type="image/png">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

        <style>[x-cloak]{display:none!important;}</style>

        <script>
            (function() {
                try {
                    var theme = localStorage.getItem('theme');
                    var isDark = theme === 'dark';
                    if (isDark) {
                        document.documentElement.classList.add('dark');
                    } else {
                        document.documentElement.classList.remove('dark');
                    }
                } catch (e) {}
            })();
        </script>

        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-[Poppins] antialiased bg-[#FFEFE6] dark:bg-slate-900 text-slate-800 dark:text-slate-100">
        <div x-data="{ openSidebar: false }" class="min-h-screen">
            <div class="relative min-h-screen lg:grid lg:grid-cols-[250px,1fr]">
                <aside
                    x-cloak
                    :class="openSidebar ? 'translate-x-0' : '-translate-x-full'"
                    class="fixed inset-y-0 left-0 z-50 flex w-64 flex-col overflow-y-auto border-r border-[#FAD4C2]/50 dark:border-slate-800 bg-white dark:bg-slate-900 backdrop-blur-sm shadow-xl transition-transform duration-300 ease-in-out lg:static lg:flex lg:w-[250px] lg:translate-x-0 lg:shadow-none">
                    <div class="border-b border-[#FAD4C2]/40 dark:border-slate-800 px-5 py-5">
                        <div class="flex items-center gap-3">
                            @if(!empty($brandLogoUrl))
                                <img src="{{ $brandLogoUrl }}" alt="{{ $brandName }} Logo" class="h-10 w-10 rounded-xl border border-[#FAD4C2]/60 dark:border-slate-700 object-cover shadow-sm">
                            @else
                                <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-[#FFE2CF] to-[#F7BFA0] text-base font-bold text-[#C26A3D] shadow-sm">
                                    {{ \Illuminate\Support\Str::of($brandName)->substr(0, 2)->upper() }}
                                </div>
                            @endif
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-bold text-slate-900 dark:text-slate-100 truncate">{{ $brandName }}</p>
                                <p class="text-[10px] text-slate-500 dark:text-slate-400 truncate">{{ $brandTagline }}</p>
                            </div>
                        </div>
                    </div>

                    <nav class="flex-1 px-3 py-4 text-sm font-medium">
                        <ul class="space-y-1">
                            @foreach ($navItems as $item)
                                @php
                                    $isActive = str_starts_with($currentRoute, $item['route']);
                                @endphp
                                <li>
                                    <a href="{{ route($item['route']) }}"
                                        @click="openSidebar = false"
                                        class="flex items-center gap-3 rounded-xl px-3 py-2.5 transition-all duration-200 {{ $isActive ? 'bg-gradient-to-r from-[#C26A3D] to-[#F5703B] text-white shadow-md shadow-[#C26A3D]/20' : 'text-slate-600 dark:text-slate-300 hover:bg-[#FFF5EE] dark:hover:bg-slate-800/50 hover:text-[#C26A3D] dark:hover:text-amber-200' }}">
                                        <span class="inline-flex h-8 w-8 items-center justify-center rounded-lg text-xs {{ $isActive ? 'bg-white/20 text-white' : 'bg-[#FFEFE6] dark:bg-slate-800 text-[#C26A3D] dark:text-slate-200' }}">
                                            @switch($item['icon'])
                                                @case('grid')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M6 6h4v4H6zM14 6h4v4h-4zM6 14h4v4H6zM14 14h4v4h-4z"/>
                                                    </svg>
                                                @break
                                                @case('chart')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M4 17h16"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M6.5 12l3-4 4 5 4-7 2.5 5"/>
                                                        <circle cx="6.5" cy="12" r="1" fill="currentColor"/>
                                                        <circle cx="9.5" cy="8" r="1" fill="currentColor"/>
                                                        <circle cx="13.5" cy="13" r="1" fill="currentColor"/>
                                                        <circle cx="17.5" cy="6" r="1" fill="currentColor"/>
                                                    </svg>
                                                @break
                                                @case('box')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M5 8l7-3 7 3"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M19 8v10l-7 4-7-4V8"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M12 5v7"/>
                                                    </svg>
                                                @break
                                                @case('category')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M4 6h8v5H4z"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M12 6h8v5h-8z"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M4 15h16v3H4z"/>
                                                    </svg>
                                                @break
                                                @case('discount')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <rect x="3" y="8" width="18" height="8" rx="2" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M3 12h3M18 12h3"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M8 12h8"/>
                                                    </svg>
                                                @break
                                                @case('cart')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M5 7h2l1.5 6.5h9L19 8h2"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M7 20a1 1 0 100-2 1 1 0 000 2zM17 20a1 1 0 100-2 1 1 0 000 2z"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M10 12h3"/>
                                                    </svg>
                                                @break
                                                @case('wallet')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M3 9h18v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3z"/>
                                                        <line x1="3" y1="12" x2="21" y2="12" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"/>
                                                        <circle cx="18" cy="13.5" r="1.2" fill="currentColor"/>
                                                    </svg>
                                                @break
                                                @case('pos')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <rect x="4" y="6" width="16" height="12" rx="2" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M4 13h16"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M9 17h6"/>
                                                    </svg>
                                                @break
                                                @case('customers')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <circle cx="9" cy="9" r="3" stroke="currentColor" stroke-width="1.6"/>
                                                        <circle cx="16" cy="11" r="2.5" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M3 20c2.5-2.5 6-2.5 9-2.5s6.5 0 9 2.5"/>
                                                    </svg>
                                                @break
                                                @case('payments')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <rect x="3" y="6" width="18" height="12" rx="2" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M3 10h18"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M7 15h5"/>
                                                    </svg>
                                                @break
                                                @case('shipping')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" d="M3 13h10l3 4h5v-6l-3-3H7z"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M3 13v-4h4"/>
                                                        <circle cx="6.5" cy="18" r="1.5" stroke="currentColor" stroke-width="1.6"/>
                                                        <circle cx="17.5" cy="18" r="1.5" stroke="currentColor" stroke-width="1.6"/>
                                                    </svg>
                                                @break
                                                @case('users')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <circle cx="12" cy="9" r="3.5" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" d="M4 20a8 8 0 0116 0"/>
                                                    </svg>
                                                @break
                                                @case('settings')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="1.6"/>
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" d="M19.4 15a1.65 1.65 0 00.33 1.82l.06.06a2 2 0 11-2.83 2.83l-.06-.06A1.65 1.65 0 0015 19.4a1.65 1.65 0 00-1 .6 1.65 1.65 0 00-.33 1.82 2 2 0 11-3.34 0 1.65 1.65 0 00-.33-1.82 1.65 1.65 0 00-1-.6 1.65 1.65 0 00-1.82.33 2 2 0 11-2.83-2.83A1.65 1.65 0 00.33-1.82 1.65 1.65 0 00-1-.6 2 2 0 110-3.34 1.65 1.65 0 00.6-1 1.65 1.65 0 00-.6-1.82 2 2 0 112.83-2.83A1.65 1.65 0 0020 10c.36.28.6.7.6 1.16 0 .46-.24.88-.6 1.16z"/>
                                                    </svg>
                                                @break
                                                @case('activity')
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" d="M3 12h4l3 7 4-14 3 7h4"/>
                                                    </svg>
                                                @break
                                                @default
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" class="h-4 w-4">
                                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6" d="M4 6h16v12H4z"/>
                                                        <path stroke="currentColor" stroke-linecap="round" stroke-width="1.6" d="M4 11h16"/>
                                                    </svg>
                                                @break
                                            @endswitch
                                        </span>
                                        <span>{{ $item['label'] }}</span>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </nav>

                    <div class="border-t border-[#FAD4C2]/40 dark:border-slate-800 px-4 py-4 space-y-2">
                        <a href="https://wa.me/{{ $adminWhatsapp }}" class="flex w-full items-center justify-center gap-2 rounded-xl border border-[#C26A3D]/30 bg-gradient-to-r from-emerald-50 to-emerald-100 px-3 py-2.5 text-xs font-semibold text-emerald-700 hover:from-emerald-100 hover:to-emerald-200 dark:from-emerald-900/30 dark:to-emerald-800/30 dark:text-emerald-300 transition">
                            <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
                            </svg>
                            WhatsApp
                        </a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <button type="submit" class="flex w-full items-center justify-center gap-2 rounded-xl border border-slate-300 dark:border-slate-700 bg-white dark:bg-slate-800 px-3 py-2.5 text-xs font-semibold text-slate-700 dark:text-slate-200 hover:bg-slate-50 dark:hover:bg-slate-700 transition">
                                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                                </svg>
                                Keluar
                            </button>
                        </form>
                    </div>
                </aside>
                <div
                    x-show="openSidebar"
                    x-transition.opacity
                    @click="openSidebar = false"
                    class="fixed inset-0 z-40 bg-black/40 lg:hidden">
                </div>

                <main class="relative flex min-h-screen flex-col bg-gradient-to-br from-[#FFEFE6] via-white to-[#FFF7F2] dark:from-slate-900 dark:via-slate-900 dark:to-slate-950">
                    <header class="border-b border-[#FAD4C2]/40 dark:border-slate-800 bg-white/90 dark:bg-slate-900/90 backdrop-blur-sm sticky top-0 z-30 shadow-sm">
                        <div class="flex h-14 sm:h-16 w-full items-center justify-between gap-2 px-3 sm:px-4 lg:px-6">
                            <div class="flex items-center gap-2 sm:gap-3 flex-1 min-w-0">
                                <button
                                    type="button"
                                    class="inline-flex items-center justify-center rounded-lg border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 p-2 text-[#C26A3D] dark:text-slate-100 transition hover:bg-[#FFE2CF] dark:hover:bg-slate-700 focus:outline-none focus:ring-2 focus:ring-[#C26A3D]/20 lg:hidden shrink-0"
                                    @click="openSidebar = true">
                                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                    </svg>
                                    <span class="sr-only">Buka menu</span>
                                </button>
                                @isset($pageTitle)
                                    <div class="min-w-0 flex-1">
                                        <h1 class="text-base sm:text-lg font-bold text-slate-900 dark:text-slate-100 truncate">{{ $pageTitle }}</h1>
                                        @isset($pageSubtitle)
                                            <p class="text-[10px] sm:text-xs text-slate-500 dark:text-slate-400 mt-0.5 truncate hidden sm:block">{{ $pageSubtitle }}</p>
                                        @endisset
                                    </div>
                                @endisset
                            </div>
                            <div class="flex items-center gap-1.5 sm:gap-2 text-sm shrink-0">
                                @php
                                    $unpaidCount = \App\Models\Order::where('payment_status', '!=', 'paid')->count();
                                    $waitingOrdersCount = \App\Models\Order::whereIn('status', ['pending', 'confirmed'])->count();
                                    $notificationCount = $unpaidCount + $waitingOrdersCount;
                                @endphp
                                <div x-data="{ open: false }" class="relative">
                                    <button type="button" @click="open = !open" class="relative inline-flex items-center justify-center rounded-lg border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 p-1.5 sm:p-2 text-[#C26A3D] dark:text-slate-100 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 transition">
                                        <svg class="h-4 w-4 sm:h-5 sm:w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                                        </svg>
                                        @if($notificationCount > 0)
                                            <span class="absolute -top-0.5 -right-0.5 flex h-4 w-4 sm:h-5 sm:w-5 items-center justify-center rounded-full bg-red-500 text-[9px] sm:text-[10px] font-bold text-white">{{ $notificationCount > 9 ? '9+' : $notificationCount }}</span>
                                        @endif
                                    </button>
                                    <div x-show="open" @click.away="open = false" x-cloak x-transition class="absolute right-0 mt-2 w-72 sm:w-80 rounded-xl border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 shadow-xl z-50 max-h-[80vh] overflow-y-auto">
                                        <div class="p-4 border-b border-[#FAD4C2]/40 dark:border-slate-700">
                                            <h3 class="text-sm font-bold text-slate-900 dark:text-white">Notifikasi</h3>
                                        </div>
                                        <div class="max-h-96 overflow-y-auto">
                                            @if($unpaidCount > 0)
                                                <a href="{{ route('admin.orders.index', ['payment_status' => 'unpaid']) }}" class="flex items-start gap-3 p-4 hover:bg-[#FFF7F2] dark:hover:bg-slate-700 transition">
                                                    <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-amber-100 dark:bg-amber-900/30">
                                                        <svg class="h-5 w-5 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                        </svg>
                                                    </div>
                                                    <div class="flex-1">
                                                        <p class="text-sm font-semibold text-slate-900 dark:text-white">Pembayaran Belum Diterima</p>
                                                        <p class="text-xs text-slate-500 dark:text-slate-400 mt-1">{{ $unpaidCount }} pesanan menunggu pembayaran</p>
                                                    </div>
                                                </a>
                                            @endif
                                            @if($waitingOrdersCount > 0)
                                                <a href="{{ route('admin.orders.index', ['status' => 'pending']) }}" class="flex items-start gap-3 p-4 hover:bg-[#FFF7F2] dark:hover:bg-slate-700 transition">
                                                    <div class="flex h-10 w-10 items-center justify-center rounded-lg bg-blue-100 dark:bg-blue-900/30">
                                                        <svg class="h-5 w-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                        </svg>
                                                    </div>
                                                    <div class="flex-1">
                                                        <p class="text-sm font-semibold text-slate-900 dark:text-white">Pesanan Menunggu</p>
                                                        <p class="text-xs text-slate-500 dark:text-slate-400 mt-1">{{ $waitingOrdersCount }} pesanan perlu diproses</p>
                                                    </div>
                                                </a>
                                            @endif
                                            @if($notificationCount === 0)
                                                <div class="p-8 text-center">
                                                    <svg class="mx-auto h-12 w-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                                                    </svg>
                                                    <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">Tidak ada notifikasi</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <button type="button" data-theme-toggle class="inline-flex items-center justify-center rounded-lg border border-[#FAD4C2]/60 dark:border-slate-700 bg-white dark:bg-slate-800 p-1.5 sm:p-2 text-[#C26A3D] dark:text-slate-100 hover:bg-[#FFE2CF] dark:hover:bg-slate-700 transition">
                                    <svg class="h-4 w-4 block dark:hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v2m0 14v2m9-9h-2M5 12H3m15.364 6.364-1.414-1.414M7.05 7.05 5.636 5.636m12.728 0-1.414 1.414M7.05 16.95l-1.414 1.414M12 8a4 4 0 100 8 4 4 0 000-8z" /></svg>
                                    <svg class="h-4 w-4 hidden dark:block" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z" /></svg>
                                </button>

                                {{-- Real-time Clock --}}
                                <div class="hidden md:flex items-center gap-2 px-3 py-1.5 rounded-lg bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 border border-blue-200 dark:border-blue-800">
                                    <svg class="h-4 w-4 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <div class="text-xs">
                                        <div id="realtime-clock" class="font-bold text-blue-700 dark:text-blue-300 tabular-nums">--:--:--</div>
                                        <div id="realtime-date" class="text-[10px] text-blue-600 dark:text-blue-400 leading-tight">-- --- ----</div>
                                    </div>
                                </div>

                                <div class="hidden sm:flex items-center gap-2 px-3 py-1.5 rounded-lg bg-slate-50 dark:bg-slate-800">
                                    <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-gradient-to-br from-[#C26A3D] to-[#F5703B] text-white text-xs font-bold shadow-sm">
                                        {{ \Illuminate\Support\Str::take(auth()->user()->name, 1) }}
                                    </div>
                                    <span class="text-xs font-medium text-slate-700 dark:text-slate-200 max-w-[100px] truncate">{{ auth()->user()->name }}</span>
                                </div>
                            </div>
                        </div>
                    </header>

                    @php
                        $flashMessage = session('status') ?? session('success') ?? session('error') ?? session('warning');
                        $flashType = session()->has('error') ? 'error' : (session()->has('warning') ? 'warning' : 'success');
                    @endphp

                    @if ($flashMessage)
                        <div
                            x-data="{ show: true }"
                            x-show="show"
                            x-init="setTimeout(() => show = false, 3600)"
                            x-transition
                            class="fixed right-4 top-4 z-50 w-[92vw] max-w-sm sm:max-w-md"
                        >
                            <div class="flex items-start gap-3 rounded-2xl border px-4 py-3 shadow-lg shadow-[#FAD4C2]/30"
                                :class="{
                                    'border-emerald-200 bg-emerald-50 text-emerald-800': '{{ $flashType }}' === 'success',
                                    'border-amber-200 bg-amber-50 text-amber-800': '{{ $flashType }}' === 'warning',
                                    'border-rose-200 bg-rose-50 text-rose-800': '{{ $flashType }}' === 'error',
                                }"
                            >
                                <div class="mt-0.5 flex h-9 w-9 items-center justify-center rounded-full"
                                    :class="{
                                        'bg-emerald-100 text-emerald-700': '{{ $flashType }}' === 'success',
                                        'bg-amber-100 text-amber-700': '{{ $flashType }}' === 'warning',
                                        'bg-rose-100 text-rose-700': '{{ $flashType }}' === 'error',
                                    }"
                                >
                                    @if ($flashType === 'error')
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01M5.64 5.64l12.72 12.72M4.93 19.07A9 9 0 0119.07 4.93" />
                                        </svg>
                                    @elseif ($flashType === 'warning')
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M4.93 19.07a9 9 0 1114.14 0 9 9 0 01-14.14 0z" />
                                        </svg>
                                    @else
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                        </svg>
                                    @endif
                                </div>
                                <div class="flex-1">
                                    <p class="text-sm font-semibold leading-tight">{{ $flashMessage }}</p>
                                </div>
                                <button type="button" @click="show = false" class="mt-0.5 text-xs font-semibold text-slate-500 hover:text-slate-700">
                                    Tutup
                                </button>
                            </div>
                        </div>
                    @endif

                    @if ($errors->any())
                        @php
                            $shownErrors = collect($errors->all())->take(3);
                        @endphp
                        <div class="px-3 pt-4 sm:px-4 lg:px-6">
                            <div class="rounded-xl border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-700">
                                <p class="font-semibold">Formulir belum lengkap.</p>
                                <ul class="mt-2 list-disc space-y-1 pl-4">
                                    @foreach ($shownErrors as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                    @if ($errors->count() > $shownErrors->count())
                                        <li>{{ $errors->count() - $shownErrors->count() }} kesalahan lain silakan periksa kembali.</li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    @endif

                    <div class="flex-1 w-full px-3 py-4 sm:px-4 sm:py-5 lg:px-6 lg:py-6 max-w-[100vw] lg:max-w-none overflow-x-hidden">
                        {{ $slot }}
                    </div>
                </main>
            </div>
        </div>

        {{-- Real-time Clock Script --}}
        <script>
            (function() {
                function updateClock() {
                    const now = new Date();

                    // Format time (HH:MM:SS)
                    const hours = String(now.getHours()).padStart(2, '0');
                    const minutes = String(now.getMinutes()).padStart(2, '0');
                    const seconds = String(now.getSeconds()).padStart(2, '0');
                    const timeString = `${hours}:${minutes}:${seconds}`;

                    // Format date in Indonesian
                    const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
                    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];

                    const dayName = days[now.getDay()];
                    const day = now.getDate();
                    const month = months[now.getMonth()];
                    const year = now.getFullYear();
                    const dateString = `${dayName}, ${day} ${month} ${year}`;

                    // Update DOM - Header Clock
                    const clockElement = document.getElementById('realtime-clock');
                    const dateElement = document.getElementById('realtime-date');

                    if (clockElement) {
                        clockElement.textContent = timeString;
                    }
                    if (dateElement) {
                        dateElement.textContent = dateString;
                    }
                }

                // Update immediately
                updateClock();

                // Update every second
                setInterval(updateClock, 1000);
            })();
        </script>

        @stack('scripts')
    </body>
</html>
