@php
    $brandLogo = \App\Models\StoreSetting::getValue('store.logo', 'assets/logo-dshop.png');
    $brandName = \App\Models\StoreSetting::getValue('store.name', config('app.name', "D'Shop"));
    if (!empty($brandLogo) && !preg_match('/^(https?:)?\\/\\//', $brandLogo) && ! str_starts_with($brandLogo, 'data:')) {
        $brandLogo = asset($brandLogo);
    }
@endphp
<x-app-layout>
    <!-- Hero Carousel Section -->
    <section x-data="carouselBanner()" class="relative overflow-hidden bg-gradient-to-br from-[#FFE7D4] via-[#FFF7F2] to-white dark:from-slate-900 dark:via-slate-900 dark:to-slate-900">
        <!-- Carousel Container -->
        <div class="relative min-h-[70vh] sm:min-h-[75vh] md:min-h-[80vh] lg:min-h-[85vh]">
            @foreach($banners as $index => $banner)
                <div x-show="currentSlide === {{ $index }}"
                     x-transition:enter="transition ease-out duration-500"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="transition ease-in duration-300"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="absolute inset-0">
                    <div class="relative h-full w-full">
                        <!-- Background Image dengan Overlay -->
                        <div class="absolute inset-0 bg-cover bg-center bg-no-repeat" style="background-image: url('{{ $banner['image'] }}');">
                            <div class="absolute inset-0 bg-gradient-to-r from-black/70 via-black/50 to-black/30"></div>
                        </div>

                        <!-- Content Overlay -->
                        <div class="relative h-full max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center">
                            <div class="max-w-2xl space-y-6 text-white text-center sm:text-left mx-auto">
                                <span class="inline-flex items-center gap-2 rounded-full bg-white/20 backdrop-blur-sm px-5 py-2.5 text-xs font-bold uppercase tracking-wider text-white shadow-lg">
                                    @if(!empty($brandLogo))
                                        <img src="{{ $brandLogo }}" alt="{{ $brandName }} Logo" class="h-6 w-6 rounded-full border border-white/60 object-cover">
                                    @endif
                                    {{ $brandName }} Online Store
                                </span>
                                <h1 class="text-4xl sm:text-5xl lg:text-6xl xl:text-7xl font-bold leading-tight drop-shadow-2xl">
                                    {{ $banner['title'] }}
                                </h1>
                                <p class="text-lg sm:text-xl lg:text-2xl text-white/90 max-w-xl leading-relaxed drop-shadow-lg">
                                    {{ $banner['subtitle'] }}
                                </p>
                                <div class="flex flex-col gap-4 pt-2 sm:flex-row sm:flex-wrap sm:items-center">
                                    <a href="{{ $banner['link'] }}" class="inline-flex w-full justify-center items-center gap-2 rounded-xl bg-gradient-to-r from-[#C26A3D] to-orange-500 px-8 py-4 text-base font-bold text-white shadow-xl shadow-orange-500/30 hover:from-[#a85327] hover:to-orange-600 transition transform hover:scale-105 sm:w-auto">
                                        {{ $banner['button_text'] }}
                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                        </svg>
                                    </a>
                                    <a href="https://wa.me/{{ $adminWhatsapp }}" class="inline-flex w-full justify-center items-center gap-2 rounded-xl border-2 border-white/80 bg-white/10 backdrop-blur-sm px-8 py-4 text-base font-bold text-white hover:bg-white/20 transition sm:w-auto">
                                        <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.25 6.75A4.5 4.5 0 016.75 2.25h.5A4.5 4.5 0 0111.75 6.75v1.5a1.5 1.5 0 001.5 1.5h1.5a4.5 4.5 0 014.5 4.5v.5a4.5 4.5 0 01-4.5 4.5h-.5a4.5 4.5 0 01-4.5-4.5v-1.5a1.5 1.5 0 00-1.5-1.5h-1.5a4.5 4.5 0 01-4.5-4.5v-.5z" />
                                        </svg>
                                        Konsultasi WhatsApp
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach

            <!-- Navigation Arrows -->
            <button @click="prevSlide()" class="absolute left-4 top-1/2 -translate-y-1/2 z-20 rounded-full bg-white/20 backdrop-blur-md p-3 text-white hover:bg-white/30 transition shadow-lg">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
            </button>
            <button @click="nextSlide()" class="absolute right-4 top-1/2 -translate-y-1/2 z-20 rounded-full bg-white/20 backdrop-blur-md p-3 text-white hover:bg-white/30 transition shadow-lg">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </button>

            <!-- Dots Indicator -->
            <div class="absolute bottom-8 left-1/2 -translate-x-1/2 z-20 flex gap-2">
                @foreach($banners as $index => $banner)
                    <button @click="currentSlide = {{ $index }}"
                            :class="currentSlide === {{ $index }} ? 'bg-white w-8' : 'bg-white/50 w-2'"
                            class="h-2 rounded-full transition-all duration-300"></button>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="relative bg-white py-16 lg:py-20 dark:bg-slate-900 dark:text-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-3 dark:text-white">Kenapa Pilih D'Shop Online?</h2>
                <p class="text-lg text-slate-600 max-w-2xl mx-auto dark:text-slate-300">Solusi lengkap untuk kebutuhan belanja online Anda dengan kualitas terbaik</p>
            </div>
            <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
                <div class="group relative rounded-3xl bg-gradient-to-br from-[#FFF8F3] to-white p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-[#FAD4C2]/50 dark:border-slate-700 dark:from-slate-900 dark:via-slate-900 dark:to-slate-800">
                    <div class="absolute -top-6 -right-6 h-20 w-20 rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-400 opacity-20 blur-2xl"></div>
                    <div class="relative">
                        <div class="inline-flex items-center justify-center h-14 w-14 rounded-2xl bg-gradient-to-br from-[#C26A3D] to-orange-400 mb-4 shadow-lg">
                            <svg class="h-7 w-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.25 18.75a60.07 60.07 0 0115.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 013 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 00-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 01-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 003 15h-.75M15 10.5a3 3 0 11-6 0 3 3 0 016 0zm3 0h.008v.008H18V10.5zm-12 0h.008v.008H6V10.5z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 dark:text-white">Pembayaran Terintegrasi</h3>
                        <p class="text-sm text-slate-600 leading-relaxed dark:text-slate-300">Midtrans, transfer manual, dan berbagai metode pembayaran lainnya. Proses pembayaran yang mudah, cepat, dan aman.</p>
                    </div>
                </div>
                <div class="group relative rounded-3xl bg-gradient-to-br from-[#FFF8F3] to-white p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-[#FAD4C2]/50 dark:border-slate-700 dark:from-slate-900 dark:via-slate-900 dark:to-slate-800">
                    <div class="absolute -top-6 -right-6 h-20 w-20 rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-400 opacity-20 blur-2xl"></div>
                    <div class="relative">
                        <div class="inline-flex items-center justify-center h-14 w-14 rounded-2xl bg-gradient-to-br from-[#C26A3D] to-orange-400 mb-4 shadow-lg">
                            <svg class="h-7 w-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 002.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 00-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 00.75-.75 2.25 2.25 0 00-.1-.664m-5.8 0A2.251 2.251 0 0113.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25zM6.75 12h.008v.008H6.75V12zm0 3h.008v.008H6.75V15zm0 3h.008v.008H6.75V18z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 dark:text-white">Produk Berkualitas</h3>
                        <p class="text-sm text-slate-600 leading-relaxed dark:text-slate-300">Koleksi produk fashion, kecantikan, dan lifestyle terbaik dengan kualitas premium dan harga terjangkau.</p>
                    </div>
                </div>
                <div class="group relative rounded-3xl bg-gradient-to-br from-[#FFF8F3] to-white p-8 shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-[#FAD4C2]/50 sm:col-span-2 lg:col-span-1 dark:border-slate-700 dark:from-slate-900 dark:via-slate-900 dark:to-slate-800">
                    <div class="absolute -top-6 -right-6 h-20 w-20 rounded-full bg-gradient-to-br from-[#C26A3D] to-orange-400 opacity-20 blur-2xl"></div>
                    <div class="relative">
                        <div class="inline-flex items-center justify-center h-14 w-14 rounded-2xl bg-gradient-to-br from-[#C26A3D] to-orange-400 mb-4 shadow-lg">
                            <svg class="h-7 w-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m13.5 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H20.25M2.25 6.75h19.5m-19.5 0h.008v.008H2.25V6.75zm19.5 6.75h-7.5v-.008h7.5v.008z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 dark:text-white">Pengiriman Cepat</h3>
                        <p class="text-sm text-slate-600 leading-relaxed dark:text-slate-300">JNE, J&T, Anteraja atau ambil langsung. Pilihan pengiriman yang fleksibel dan cepat sampai ke Anda.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Categories Section - Modern & Colorful -->
    <section class="bg-gradient-to-b from-white to-[#FFF7F2] py-12 sm:py-16 lg:py-20 dark:from-[#020617] dark:via-slate-900 dark:to-slate-900">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Header Section -->
            <div class="text-center mb-10 sm:mb-12">
                <div class="inline-flex items-center gap-2 rounded-full bg-gradient-to-r from-pink-100 to-purple-100 dark:from-pink-900/30 dark:to-purple-900/30 px-4 py-2 mb-4">
                    <svg class="h-5 w-5 text-pink-600 dark:text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    <span class="text-sm font-bold text-pink-700 dark:text-pink-300">KATEGORI PRODUK</span>
                </div>
                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-slate-900 mb-3 dark:text-white">Belanja Berdasarkan Kategori</h2>
                <p class="text-base sm:text-lg text-slate-600 max-w-2xl mx-auto dark:text-slate-300">Temukan produk favorit Anda dari berbagai kategori pilihan</p>
            </div>

            <!-- Categories Grid -->
            <div class="grid gap-4 sm:gap-6 grid-cols-2 lg:grid-cols-3">
                @php
                    $categoryColors = [
                        'Produk Kecantikan' => ['from' => 'from-pink-500', 'to' => 'to-rose-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>'],
                        'Fashion' => ['from' => 'from-purple-500', 'to' => 'to-indigo-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>'],
                        'Mainan Anak' => ['from' => 'from-yellow-400', 'to' => 'to-orange-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>'],
                        'Produk Rumah Tangga' => ['from' => 'from-emerald-500', 'to' => 'to-teal-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>'],
                        'Elektronik' => ['from' => 'from-blue-500', 'to' => 'to-cyan-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>'],
                        'Alat Tulis' => ['from' => 'from-amber-500', 'to' => 'to-red-500', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>'],
                    ];
                @endphp
                
                @foreach ($categories as $category)
                    @php
                        $colors = $categoryColors[$category->name] ?? ['from' => 'from-slate-500', 'to' => 'to-slate-600', 'icon' => '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>'];
                    @endphp
                    
                    <a href="{{ route('products.index', ['category' => $category->slug]) }}" class="group relative overflow-hidden rounded-2xl sm:rounded-3xl shadow-lg transition-all duration-300 hover:shadow-2xl hover:-translate-y-2">
                        <!-- Background Image -->
                        <div class="relative h-48 sm:h-56 lg:h-64 overflow-hidden">
                            @if($category->carousel_image_url || $category->hero_image_url)
                                @php
                                    $imageUrl = $category->carousel_image_url ?? $category->hero_image_url;
                                    // Cek apakah URL external atau lokal
                                    if (!preg_match('/^(https?:)?\/\//', $imageUrl)) {
                                        $imageUrl = asset($imageUrl);
                                    }
                                @endphp
                                <img src="{{ $imageUrl }}" 
                                     alt="{{ $category->name }}" 
                                     class="h-full w-full object-cover transition-transform duration-700 group-hover:scale-110">
                            @else
                                <div class="h-full w-full bg-gradient-to-br {{ $colors['from'] }} {{ $colors['to'] }}"></div>
                            @endif
                            
                            <!-- Gradient Overlay -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/50 to-black/20 group-hover:from-black/95 transition-colors duration-300"></div>
                            
                            <!-- Icon Badge -->
                            <div class="absolute top-4 right-4 rounded-xl bg-white/20 backdrop-blur-md p-3 shadow-xl group-hover:scale-110 transition-transform duration-300">
                                <svg class="h-6 w-6 sm:h-7 sm:w-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    {!! $colors['icon'] !!}
                                </svg>
                            </div>
                            
                            <!-- Content -->
                            <div class="absolute inset-0 flex flex-col justify-end p-4 sm:p-6">
                                <div class="space-y-2 sm:space-y-3">
                                    <h3 class="text-xl sm:text-2xl lg:text-3xl font-bold text-white drop-shadow-2xl">
                                        {{ $category->name }}
                                    </h3>
                                    
                                    @if($category->tagline)
                                        <p class="text-xs sm:text-sm text-white/90 line-clamp-2 drop-shadow-lg">
                                            {{ $category->tagline }}
                                        </p>
                                    @endif
                                    
                                    <!-- CTA Button -->
                                    <div class="flex items-center gap-2 pt-2">
                                        <span class="inline-flex items-center gap-2 rounded-full bg-white/20 backdrop-blur-sm px-3 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm font-bold text-white shadow-lg group-hover:bg-white group-hover:text-slate-900 transition-all duration-300">
                                            <span>Belanja Sekarang</span>
                                            <svg class="h-4 w-4 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
            
            <!-- View All Categories Button -->
            <div class="text-center mt-10 sm:mt-12">
                <a href="{{ route('products.index') }}" class="inline-flex items-center gap-2 rounded-full bg-gradient-to-r from-[#C26A3D] to-[#F5703B] px-6 sm:px-8 py-3 sm:py-4 text-sm sm:text-base font-bold text-white shadow-xl transition-all duration-300 hover:scale-105 hover:shadow-2xl">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"></path>
                    </svg>
                    <span>Lihat Semua Produk</span>
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                    </svg>
                </a>
            </div>
        </div>
    </section>

    <!-- Featured Categories Sidebar -->
    <section class="bg-white py-16 lg:py-20 dark:bg-slate-900 dark:text-slate-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid gap-12 lg:grid-cols-[1fr,400px]">
                <!-- New Arrivals Products -->
                <div>
                    <div class="flex flex-col sm:flex-row sm:items-end sm:justify-between gap-4 mb-8">
                        <div>
                            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-2 dark:text-white">Produk Terbaru D'Shop</h2>
                            <p class="text-base text-slate-600 dark:text-slate-300">Produk terbaru dan favorit pelanggan dengan kualitas terbaik</p>
                        </div>
                        <a href="{{ route('products.index') }}" class="inline-flex items-center gap-2 text-sm font-semibold text-[#C26A3D] hover:text-orange-600 hover:underline transition dark:text-orange-400">
                            Lihat semua produk
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                            </svg>
                        </a>
                    </div>

                    <div class="grid gap-6 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3">
                        @foreach ($newArrivals as $product)
                            <div class="group relative rounded-3xl border-2 border-[#FAD4C2] bg-gradient-to-br from-[#FFF8F3] to-white p-5 shadow-md hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 hover:border-[#C26A3D] dark:border-slate-700 dark:from-slate-900 dark:via-slate-900 dark:to-slate-800">
                                <div class="relative h-48 overflow-hidden rounded-2xl bg-white mb-4 dark:bg-slate-900/60">
                                    <img src="{{ $product->thumbnail }}" alt="{{ $product->name }}" class="absolute inset-0 h-full w-full object-cover transition-transform duration-500 group-hover:scale-110">
                                    @if($product->discount_percent > 0)
                                        <span class="absolute top-3 right-3 rounded-full bg-gradient-to-r from-red-500 to-pink-500 px-3 py-1 text-xs font-bold text-white shadow-lg">
                                            -{{ $product->discount_percent }}%
                                        </span>
                                    @endif
                                </div>
                                <div class="space-y-2">
                                     <span class="inline-flex rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-bold text-[#C26A3D] uppercase tracking-wide dark:bg-slate-800 dark:text-slate-100">{{ $product->category->name }}</span>
                                     <a href="{{ route('products.show', $product) }}" class="block text-base font-bold text-slate-900 leading-tight hover:text-[#C26A3D] transition line-clamp-2 dark:text-white">{{ $product->name }}</a>
                                     <p class="text-sm text-slate-600 h-[40px] overflow-hidden line-clamp-2 dark:text-slate-300">{{ $product->summary }}</p>
                                    <div class="flex items-baseline gap-2">
                                        <p class="text-2xl font-bold text-[#C26A3D]">Rp{{ number_format($product->final_price, 0, ',', '.') }}</p>
                                        @if($product->discount_percent > 0)
                                            <p class="text-sm text-slate-400 line-through">Rp{{ number_format($product->price, 0, ',', '.') }}</p>
                                        @endif
                                    </div>
                                </div>
                                <div class="mt-5 flex gap-2">
                                    <form
                                        action="{{ route('cart.store') }}"
                                        method="POST"
                                        class="flex-1"
                                        data-add-to-cart-form
                                        data-product-name="{{ $product->name }}"
                                        data-product-image="{{ $product->thumbnail }}"
                                    >
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                                        <input type="hidden" name="quantity" value="1" data-cart-quantity>
                                        <button type="submit" class="w-full rounded-xl bg-gradient-to-r from-[#C26A3D] to-orange-500 px-4 py-2.5 text-sm font-bold text-white shadow-lg hover:from-[#a85327] hover:to-orange-600 transition transform hover:scale-105" data-add-to-cart-button>
                                            Tambah Keranjang
                                        </button>
                                    </form>
                                     <a href="{{ route('products.show', $product) }}" class="inline-flex items-center justify-center rounded-xl border-2 border-[#C26A3D] px-4 py-2.5 text-sm font-bold text-[#C26A3D] hover:bg-[#FFE2CF] transition dark:border-slate-600 dark:text-slate-200 dark:hover:bg-slate-800">
                                        Detail
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Featured Categories Sidebar -->
                    <div class="lg:sticky lg:top-24 h-fit">
                        <div class="relative rounded-3xl border-2 border-[#FAD4C2] bg-gradient-to-br from-white to-[#FFF8F3] p-6 shadow-xl shadow-orange-100/30 dark:border-slate-700 dark:bg-gradient-to-br dark:from-slate-900 dark:to-slate-900">
                            <div class="absolute -top-4 left-6 rounded-full bg-gradient-to-r from-[#C26A3D] to-orange-500 px-4 py-1.5">
                                <span class="text-xs font-bold text-white uppercase tracking-wider">Kategori Populer</span>
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 mb-6 mt-2 dark:text-white">Rekomendasi untuk Anda</h3>
                            <div class="space-y-4">
                                @foreach ($categories->take(4) as $category)
                                <a href="{{ route('products.index', ['category' => $category->slug]) }}" class="group flex items-center gap-4 rounded-2xl border-2 border-[#FAD4C2]/60 bg-white p-4 hover:border-[#C26A3D] hover:bg-[#FFE2CF] transition-all duration-300 hover:shadow-lg dark:border-slate-700 dark:bg-slate-800/80 dark:text-slate-100 dark:hover:bg-slate-900 dark:hover:border-slate-500">
                                    <div class="h-16 w-16 flex-shrink-0 overflow-hidden rounded-xl bg-[#FFE7D4] shadow-md">
                                        @php
                                            $imgUrl = $category->hero_image_url ?? $category->carousel_image_url;
                                            if ($imgUrl && !preg_match('/^(https?:)?\/\//', $imgUrl)) {
                                                $imgUrl = asset($imgUrl);
                                            }
                                        @endphp
                                        <img src="{{ $imgUrl }}" alt="{{ $category->name }}" class="h-full w-full object-cover transition-transform duration-300 group-hover:scale-110">
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-bold text-slate-900 mb-1 truncate dark:text-white">{{ $category->name }}</p>
                                        <p class="text-xs text-slate-600 line-clamp-2 dark:text-slate-300">{{ $category->tagline }}</p>
                                    </div>
                                    <svg class="h-5 w-5 text-[#C26A3D] flex-shrink-0 transition-transform group-hover:translate-x-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        function carouselBanner() {
            return {
                currentSlide: 0,
                slides: {{ count($banners) }},
                init() {
                    // Auto-play carousel
                    setInterval(() => {
                        this.nextSlide();
                    }, 5000);
                },
                nextSlide() {
                    this.currentSlide = (this.currentSlide + 1) % this.slides;
                },
                prevSlide() {
                    this.currentSlide = (this.currentSlide - 1 + this.slides) % this.slides;
                }
            }
        }
    </script>

    <style>
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }
        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>
</x-app-layout>
