<x-app-layout>
    <section class="py-10">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8">
            <header class="space-y-3 text-center">
                <span class="inline-flex items-center rounded-full bg-[#FFE2CF] px-3 py-1 text-[11px] font-semibold uppercase tracking-wider text-[#C26A3D]">{{ $journal->published_at?->format('d M Y') ?? 'Draft' }}</span>
                <h1 class="text-3xl font-semibold text-slate-900">{{ $journal->title }}</h1>
                @if ($journal->subtitle)
                    <p class="text-sm text-slate-500">{{ $journal->subtitle }}</p>
                @endif
            </header>

            @if ($journal->hero_image)
                <div class="overflow-hidden rounded-3xl border border-[#FAD4C2] bg-[#FFE7D4]">
                    <img src="{{ $journal->hero_image }}" alt="{{ $journal->title }}" class="w-full object-cover">
                </div>
            @endif

            <article class="space-y-4 text-base leading-relaxed text-slate-700">
                {!! nl2br(e($journal->body)) !!}
            </article>

            <footer class="rounded-3xl border border-[#FAD4C2] bg-white px-6 py-4 text-sm text-slate-500">
                Ditulis oleh <span class="font-semibold text-slate-900">{{ $journal->author?->name ?? 'Admin D\'Shop' }}</span>
                @if ($journal->tags)
                    <div class="mt-3 flex flex-wrap gap-2">
                        @foreach ($journal->tags as $tag)
                            <span class="inline-flex items-center rounded-full bg-[#FFF0E6] px-3 py-1 text-[11px] font-semibold text-[#C26A3D]">#{{ $tag }}</span>
                        @endforeach
                    </div>
                @endif
            </footer>

            <div class="flex justify-center">
                <a href="{{ route('journals.index') }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-6 py-3 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">Kembali ke daftar jurnal</a>
            </div>
        </div>
    </section>
</x-app-layout>
