<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Struk Kasir {{ $order->invoice_number }}</title>
    <style>
        body { font-family: "Poppins", Arial, sans-serif; margin: 0; padding: 24px; background: #fff8f3; color: #1f2937; }
        .receipt { max-width: 640px; margin: 0 auto; background: #fff; border: 1px solid #f4c7ad; border-radius: 20px; padding: 28px; }
        h1 { font-size: 18px; margin-bottom: 4px; }
        table { width: 100%; border-collapse: collapse; margin-top: 16px; }
        th, td { padding: 8px 0; font-size: 12px; }
        tfoot td { font-weight: 600; }
        .meta { font-size: 11px; color: #6b7280; }
        @media print { body { padding: 0; background: #fff; } .receipt { border-radius: 0; border: none; } }
    </style>
</head>
<body>
    <div class="receipt">
        <header>
            <h1>{{ config('app.name', "D'Shop") }}</h1>
            <p class="meta">Invoice {{ $order->invoice_number }}  {{ $order->created_at->format('d M Y, H:i') }}</p>
        </header>

        <section>
            <table>
                <thead>
                    <tr>
                        <th style="text-align:left;">Produk</th>
                        <th style="text-align:right;">Qty</th>
                        <th style="text-align:right;">Subtotal</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($order->items as $item)
                        <tr>
                            <td>{{ $item->product_name }}</td>
                            <td style="text-align:right;">{{ $item->quantity }} x Rp{{ number_format($item->unit_price, 0, ',', '.') }}</td>
                            <td style="text-align:right;">Rp{{ number_format($item->subtotal, 0, ',', '.') }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td>Subtotal</td>
                        <td></td>
                        <td style="text-align:right;">Rp{{ number_format($order->subtotal_amount, 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Total Bayar</td>
                        <td></td>
                        <td style="text-align:right;">Rp{{ number_format($order->grand_total, 0, ',', '.') }}</td>
                    </tr>
                </tfoot>
            </table>
        </section>

        <section style="margin-top:16px; font-size:12px;">
            <p><strong>Pelanggan:</strong> {{ $order->shipping_address['recipient_name'] ?? 'Walk-in' }}</p>
            <p><strong>Kasir:</strong> {{ $order->cashier?->name ?? '-' }}</p>
            <p><strong>Status:</strong> {{ strtoupper($order->payment_status) }}</p>
        </section>

        <p class="meta" style="margin-top:20px;">Terima kasih telah berbelanja di {{ config('app.name', "D'Shop") }}.</p>
    </div>
</body>
</html>
