<x-app-layout>
    <section class="py-10">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Transaksi Kasir</h1>
                <p class="text-sm text-slate-500">Catat penjualan langsung di toko dan cetak struk instan.</p>
            </header>

            <form method="POST" action="{{ route('cashier.orders.store') }}" class="space-y-6">
                @csrf
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <h2 class="text-lg font-semibold text-slate-900">Informasi Pelanggan</h2>
                    <div class="grid gap-4 sm:grid-cols-2">
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Nama Pelanggan</label>
                            <input type="text" name="customer_name" value="{{ old('customer_name') }}" required class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-slate-600">Nomor Telepon</label>
                            <input type="text" name="customer_phone" value="{{ old('customer_phone') }}" class="mt-1 w-full rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0" />
                        </div>
                    </div>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <h2 class="text-lg font-semibold text-slate-900">Item Penjualan</h2>
                    <div class="space-y-3">
                        @foreach ($products as $product)
                            <label class="grid gap-3 rounded-2xl border border-[#FAD4C2]/60 bg-[#FFF8F3] px-4 py-3 sm:grid-cols-[auto,1fr,auto]">
                                <div class="flex items-center gap-3">
                                    <input type="checkbox" name="items[{{ $loop->index }}][product_id]" value="{{ $product->id }}" class="h-4 w-4 rounded border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                                    <div>
                                        <p class="font-semibold text-slate-900">{{ $product->name }}</p>
                                        <p class="text-xs text-slate-500">Rp{{ number_format($product->final_price, 0, ',', '.') }}</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-2">
                                    <span class="text-xs text-slate-500">Qty</span>
                                    <input type="number" name="items[{{ $loop->index }}][quantity]" value="1" min="1" class="w-20 rounded-full border border-[#FAD4C2] bg-white px-3 py-1 text-xs focus:border-[#C26A3D] focus:ring-0">
                                </div>
                                <span class="text-xs text-slate-500">Stok: {{ $product->stock }}</span>
                            </label>
                        @endforeach
                    </div>
                    <p class="text-[11px] text-slate-400">Centang produk yang dibeli, lalu atur jumlahnya.</p>
                </div>

                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm space-y-4">
                    <h2 class="text-lg font-semibold text-slate-900">Status Pembayaran</h2>
                    <div class="flex gap-3">
                        <label class="inline-flex items-center gap-2 rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-xs font-semibold text-slate-600">
                            <input type="radio" name="payment_status" value="paid" class="h-4 w-4 border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]" checked>
                            Sudah lunas (cash)
                        </label>
                        <label class="inline-flex items-center gap-2 rounded-full border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-xs font-semibold text-slate-600">
                            <input type="radio" name="payment_status" value="waiting_confirmation" class="h-4 w-4 border-[#FAD4C2] text-[#C26A3D] focus:ring-[#C26A3D]">
                            Menunggu konfirmasi
                        </label>
                    </div>
                    <label class="block text-xs font-semibold text-slate-600">
                        Catatan
                        <textarea name="notes" rows="3" class="mt-1 w-full rounded-2xl border border-[#FAD4C2] bg-[#FFF8F3] px-4 py-2 text-sm focus:border-[#C26A3D] focus:ring-0">{{ old('notes') }}</textarea>
                    </label>
                </div>

                <button type="submit" class="inline-flex items-center rounded-full bg-[#C26A3D] px-6 py-3 text-sm font-semibold text-white hover:bg-[#a85327] transition">Simpan Transaksi</button>
            </form>
        </div>
    </section>
</x-app-layout>
