<x-app-layout>
    <section class="py-10">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            <header class="space-y-2">
                <h1 class="text-2xl font-semibold text-slate-900">Dashboard Kasir</h1>
                <p class="text-sm text-slate-500">Catat penjualan offline dan pantau pembayaran pelanggan.</p>
            </header>

            <div class="grid gap-6 sm:grid-cols-3">
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                    <p class="text-sm text-slate-500">Penghasilan Hari Ini</p>
                    <p class="mt-3 text-3xl font-semibold text-[#C26A3D]">Rp{{ number_format($todayIncome, 0, ',', '.') }}</p>
                </div>
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                    <p class="text-sm text-slate-500">Pesanan Offline</p>
                    <p class="mt-3 text-3xl font-semibold text-emerald-600">{{ $todayOrders->count() }}</p>
                </div>
                <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                    <p class="text-sm text-slate-500">Menunggu Pembayaran</p>
                    <p class="mt-3 text-3xl font-semibold text-amber-600">{{ $waitingPayments->count() }}</p>
                </div>
            </div>

            <div class="rounded-3xl border border-[#FAD4C2] bg-white p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <h2 class="text-lg font-semibold text-slate-900">Pesanan Offline Hari Ini</h2>
                    <a href="{{ route('cashier.orders.create') }}" class="inline-flex items-center rounded-full bg-[#C26A3D] px-4 py-2 text-xs font-semibold text-white hover:bg-[#a85327] transition">Tambah Transaksi</a>
                </div>
                <div class="mt-4 space-y-3 text-sm text-slate-600">
                    @forelse ($todayOrders as $order)
                        <div class="rounded-2xl border border-[#FAD4C2]/60 bg-[#FFF8F3] px-4 py-3">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="font-semibold text-slate-900">{{ $order->invoice_number }}</p>
                                    <p class="text-xs text-slate-500">{{ $order->created_at->format('H:i') }}  Total Rp{{ number_format($order->grand_total, 0, ',', '.') }}</p>
                                </div>
                                <a href="{{ route('cashier.orders.show', $order) }}" class="inline-flex items-center rounded-full border border-[#C26A3D] px-4 py-2 text-xs font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">Detail</a>
                            </div>
                        </div>
                    @empty
                        <p>Belum ada transaksi hari ini.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
