@props(['title', 'subtitle' => null])
<div {{ $attributes->merge(['class' => 'group relative overflow-hidden rounded-3xl border border-slate-200/60 dark:border-slate-700/60 bg-white/80 dark:bg-slate-800/80 backdrop-blur-xl p-6 shadow-lg transition-all duration-300 hover:shadow-xl hover:border-slate-300 dark:hover:border-slate-600']) }}>
    {{-- Gradient Background --}}
    <div class="absolute inset-0 bg-gradient-to-br from-slate-50/50 via-white/50 to-blue-50/30 dark:from-slate-800/50 dark:via-slate-900/50 dark:to-slate-800/50 opacity-60"></div>
    
    {{-- Decorative Elements --}}
    <div class="absolute -right-8 -top-8 h-32 w-32 rounded-full bg-gradient-to-br from-blue-400/10 to-purple-400/10 blur-3xl transition-all duration-500 group-hover:scale-150"></div>
    
    <div class="relative z-10">
        <div class="flex flex-wrap items-center justify-between gap-3 border-b border-slate-200/50 dark:border-slate-700/50 pb-4">
        <div>
                <h2 class="text-lg font-bold text-slate-900 dark:text-slate-100 flex items-center gap-2">
                    <span class="inline-block h-1.5 w-1.5 rounded-full bg-gradient-to-r from-blue-500 to-purple-500"></span>
                    {{ $title }}
                </h2>
            @if (! empty($subtitle))
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400 font-medium">{{ $subtitle }}</p>
            @endif
        </div>
        @isset($actions)
            <div class="flex flex-wrap items-center gap-2">
                {{ $actions }}
            </div>
        @endisset
    </div>

    {{ $slot }}
    </div>
</div>
