<x-guest-layout>
    <div class="space-y-3 text-center mb-6">
        <div class="inline-flex h-16 w-16 items-center justify-center rounded-full bg-gradient-to-br from-orange-400 to-pink-500 text-2xl font-bold text-white shadow-lg">
            <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
            </svg>
        </div>
        <h1 class="text-2xl font-bold bg-gradient-to-r from-[#C26A3D] to-orange-500 bg-clip-text text-transparent">Masuk ke Akun Anda</h1>
        <p class="text-xs text-slate-500">Gunakan email atau Google untuk mengakses dashboard D'Shop</p>
    </div>

    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('login') }}" class="space-y-4">
        @csrf

        <div>
            <x-input-label for="email" value="Email" class="text-xs font-semibold text-slate-700 mb-1.5" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                    </svg>
                </div>
                <x-text-input id="email" class="block w-full pl-10 rounded-xl border-2 border-slate-200 bg-white px-4 py-2.5 text-sm focus:border-[#C26A3D] focus:ring-2 focus:ring-orange-200 transition" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" placeholder="email@example.com" />
            </div>
            <x-input-error :messages="$errors->get('email')" class="mt-1.5" />
        </div>

        <div>
            <x-input-label for="password" value="Password" class="text-xs font-semibold text-slate-700 mb-1.5" />
            <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <svg class="h-5 w-5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <x-text-input id="password" class="block w-full pl-10 pr-10 rounded-xl border-2 border-slate-200 bg-white px-4 py-2.5 text-sm focus:border-[#C26A3D] focus:ring-2 focus:ring-orange-200 transition" type="password" name="password" required autocomplete="current-password" placeholder="••••••••" />
                <button type="button" onclick="togglePassword('password')" class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-[#C26A3D] transition">
                    <svg id="password-eye" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                    <svg id="password-eye-off" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-1.5" />
        </div>

        <div class="flex items-center justify-between text-xs">
            <label for="remember_me" class="inline-flex items-center text-slate-600">
                <input id="remember_me" type="checkbox" class="h-4 w-4 rounded border-slate-300 text-[#C26A3D] focus:ring-[#C26A3D]" name="remember">
                <span class="ms-2">Ingat saya</span>
            </label>

            @if (Route::has('password.request'))
                <a class="font-semibold text-[#C26A3D] hover:text-orange-600 hover:underline transition" href="{{ route('password.request') }}">
                    Lupa password?
                </a>
            @endif
        </div>

        <button type="submit" class="w-full rounded-xl bg-gradient-to-r from-[#C26A3D] to-orange-500 px-5 py-3 text-sm font-semibold text-white shadow-lg shadow-orange-500/30 hover:from-[#a85327] hover:to-orange-600 transition transform hover:scale-[1.02] focus:outline-none focus:ring-2 focus:ring-[#C26A3D] focus:ring-offset-2">
            Masuk
        </button>
    </form>

    <div class="my-5 flex items-center gap-3 text-[11px] text-slate-400">
        <span class="flex-1 border-t border-[#FAD4C2]"></span>
        <span>atau masuk dengan</span>
        <span class="flex-1 border-t border-[#FAD4C2]"></span>
    </div>

    <a href="{{ route('auth.google.redirect') }}" class="flex items-center justify-center gap-3 rounded-xl border-2 border-[#C26A3D] bg-white px-5 py-2.5 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">
        <svg aria-hidden="true" width="18" height="18" viewBox="0 0 533.5 544.3">
            <path fill="#4285f4" d="M533.5 278.4c0-17.4-1.6-34-4.6-50.2h-261v95h150.1c-6.5 34.9-26.3 64.5-56.1 84.4v69.9h90.7c53.1-48.9 80.9-121 80.9-199.1z"/>
            <path fill="#34a853" d="M267.5 544.3c72.6 0 133.5-23.9 178-64.9l-90.7-69.9c-25.2 16.9-57.5 27-87.3 27-67 0-123.8-45.2-144.1-106.2h-92.8v70.2c44.2 88 134.8 143.8 236.9 143.8z"/>
            <path fill="#fbbc04" d="M123.4 330.3c-10.4-30.8-10.4-64.3 0-95.1v-70.2h-92.8C-31 246 3.9 383.6 123.4 475.9l92.8-70.2c-20.3-61-77.1-106.2-144.1-106.2z"/>
            <path fill="#ea4335" d="M267.5 107.7c35.8 0 68.2 12.3 93.5 36.6l70.1-70.1C401 28.8 340.1 0 267.5 0 165.4 0 74.8 55.8 30.6 143.8l92.8 70.2c20.3-61 77.1-106.3 144.1-106.3z"/>
        </svg>
        Masuk dengan Google
    </a>

    <div class="mt-5 flex flex-col gap-3">
        <a href="{{ route('register') }}" class="inline-flex justify-center rounded-xl border-2 border-[#C26A3D] bg-[#FFF0E6] px-5 py-2.5 text-sm font-semibold text-[#C26A3D] hover:bg-[#FFE2CF] transition">
            Belum punya akun? Daftar
        </a>
        <a href="{{ route('home') }}" class="inline-flex items-center justify-center gap-2 rounded-xl border-2 border-slate-200 bg-white px-5 py-2.5 text-sm font-semibold text-slate-600 hover:bg-slate-50 transition">
            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
            </svg>
            Kembali ke Menu Utama
        </a>
    </div>

    <script>
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const eye = document.getElementById(inputId + '-eye');
            const eyeOff = document.getElementById(inputId + '-eye-off');

            if (input.type === 'password') {
                input.type = 'text';
                eye.classList.add('hidden');
                eyeOff.classList.remove('hidden');
            } else {
                input.type = 'password';
                eye.classList.remove('hidden');
                eyeOff.classList.add('hidden');
            }
        }
    </script>
</x-guest-layout>
