<x-admin-layout>
    <x-slot name="pageTitle">Manajemen Pengguna</x-slot>
    <x-slot name="pageSubtitle">Atur peran (Admin, Kasir, User) dan akses.</x-slot>

    <x-admin.card title="Filter Pengguna">
        <form method="GET" class="mt-4 grid gap-4 lg:grid-cols-[2fr,1fr]">
            <x-admin.input-field label="Cari nama / email">
                <input type="text" name="search" value="{{ $search }}" class="admin-input" />
            </x-admin.input-field>
            <x-admin.input-field label="Peran">
                <select name="role" class="admin-input">
                    <option value="">Semua</option>
                    @foreach($roleOptions as $val => $label)
                        <option value="{{ $val }}" @selected($role===$val)>{{ $label }}</option>
                    @endforeach
                </select>
            </x-admin.input-field>
            <div class="lg:col-span-2 flex justify-end gap-2">
                <a href="{{ route('admin.users.index') }}" class="inline-flex items-center rounded-full border px-4 py-2 text-sm">Reset</a>
                <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-5 py-2 text-sm font-semibold text-white hover:bg-[#a85327]">Terapkan</button>
            </div>
        </form>
    </x-admin.card>

    <x-admin.card title="Daftar Pengguna">
        <div class="mt-4 overflow-hidden rounded-2xl border border-[#FAD4C2]/60 dark:border-slate-800">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-[#FAD4C2]/60 dark:divide-slate-800 text-sm">
                    <thead class="bg-[#FFF0E6] dark:bg-slate-800 text-left text-xs uppercase text-slate-500 dark:text-slate-400">
                        <tr>
                            <th class="px-4 py-3">Nama</th>
                            <th class="px-4 py-3">Email</th>
                            <th class="px-4 py-3">Peran</th>
                            <th class="px-4 py-3 text-right">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-[#FAD4C2]/40 dark:divide-slate-800 bg-white dark:bg-slate-900">
                        @forelse ($users as $u)
                            <tr class="transition hover:bg-[#FFF7F2] dark:hover:bg-slate-800">
                                <td class="px-4 py-4 font-semibold text-slate-800 dark:text-slate-100">{{ $u->name }}</td>
                                <td class="px-4 py-4">{{ $u->email }}</td>
                                <td class="px-4 py-4 uppercase">{{ $u->role->value }}</td>
                                <td class="px-4 py-4 text-right">
                                    <form method="POST" action="{{ route('admin.users.update-role', $u) }}" class="inline-flex items-center gap-2">
                                        @csrf
                                        @method('PATCH')
                                        <select name="role" class="admin-input">
                                            @foreach($roleOptions as $val => $label)
                                                <option value="{{ $val }}" @selected($u->role->value===$val)>{{ $label }}</option>
                                            @endforeach
                                        </select>
                                        <button class="inline-flex items-center rounded-full bg-[#C26A3D] px-4 py-2 text-xs font-semibold text-white hover:bg-[#a85327]">Ubah</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="px-4 py-8 text-center text-slate-500">Belum ada pengguna.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="mt-4">{{ $users->onEachSide(1)->links() }}</div>
    </x-admin.card>
</x-admin-layout>

